ORCA/M Asm65816 2.1.0

0001 F338              *******************************************************************************
0002 F338              *
0003 F338              * File: LAP.INCLUDES
0004 F338              *
0005 F338              * This file contains the 65816 implementation of LAP for the Apple IIGS.
0006 F338              * Inspiration and guidance derived from Fern Bachman's 65C02 implementation.
0007 F338              *
0008 F338              * Copyright Apple Computer, 1986
0009 F338              * Original Author: Peter Richert, Greg Seitz
0010 F338              *
0011 F338              * NOTE:
0012 F338              *   If calling internal form you must set the carry otherwise the carry is
0013 F338              *   cleared from the dispatcher (long form)
0014 F338              *
0015 F338              *******************************************************************************
0016 F338              *
0017 F338              * Notes:
0018 F338              *
0019 F338              * If the ROM version ever changes you must change the following line!
0020 F338
0021 F338              RomVer   equ   $1020                    ;Rom version 2.0.
0022 F338
0023 F338              *
0024 F338              *
0025 F338              *******************************************************************************
0026 F338              *
0027 F338              * Modification History
0028 F338              *
0029 F338              * 8/8/88    TGH     - Started working on RevD ROM 02
0030 F338              *                   - Added 3 vectors Cnxx, CnxxGo, and CnProdos to bank $E1.
0031 F338              *                     These will be patched to jump to either 00C1xx or 00C2xx.
0032 F338              *
0033 F338              * 8/23/88   TGH     - Took out CnProdos vector.  Didn't need it.
0034 F338              *
0035 F338              * 8/24/88   TGH     - Changed MID to load only the low order byte as the
0036 F338              *                     high order byte was always being written over.
0037 F338              *                   - Hard coded ROM version to 1020.  It's too hard to
0038 F338              *                     figure out whether I should load C1FE or C2FE.
0039 F338              *
0040 F338              * 10/12/88  TGH     - Changed AppleTalk slot search method.
0041 F338              *
0042 F338              * 11/9/88   TGH     - Fixed bug where BDS length = 0.
0043 F338              *
0044 F338              * 11/14/88  TGH     - Now verifing LAP type on a LAPWrite call.
0045 F338              *                     (didn't work - taken out)
0046 F338              *
0047 F338              * 11/23/88  TGH     - AppleTalk slot settings are now determined by looking
0048 F338              *                     at locations 1C0, 1C1, and 1C2 in bank E1.
0049 F338              *                   - Now verifing first BDS length on LAPWrite call.
0050 F338              *
0051 F338              * 3/27/89   TGH     - Added OnExitVector vector for QTRIRQ.
0052 F338              *
0053 F338              *******************************************************************************
0054 F338
0055 F338                       longa off
0056 F338                       longi on
0057 F338                       msb   on 
0058 F338              *	org   $ff2A27
0059 F338
0060 F338
0061 F338                       IMPORT GoComp 
0062 F338                       IMPORT QtrSched 
0063 F338                       IMPORT RestoreE1 
0064 F338                       IMPORT RestoreZP 
0065 F338                       IMPORT SaveE1 
0066 F338                       IMPORT SaveZP 
0067 F338
0068 F338
0069 F338                       ENTRY BitCount 
0070 F338                       ENTRY EnterCrit 
0071 F338                       ENTRY ExitCrit 
0072 F338                       ENTRY FindProt 
0073 F338                       ENTRY Forbid 
0074 F338                       ENTRY FreeBuf 
0075 F338                       ENTRY NewPacket 
0076 F338                       ENTRY PacketIRQ 
0077 F338                       ENTRY Permit 
0078 F338                       ENTRY QtrSecIRQ 
0079 F338                       ENTRY RTSAddr 
0080 F338                       ENTRY Random 
0081 F338                       ENTRY RecvBytes 
0082 F338                       ENTRY RecvInit 
0083 F338                       ENTRY RecvPacket 
0084 F338                       ENTRY RestorState 
0085 F338                       ENTRY SaveState 
0086 F338                       ENTRY TryNode 
0087 F338                       ENTRY WLineBusy 
0088 F338                       ENTRY XmitBDS 
0089 F338                       ENTRY XmitBegin 
0090 F338                       ENTRY XmitEnd 
0091 F338                       ENTRY XmitLAP,fXmitLAP 
0092 F338                       ENTRY XmitOne 
0093 F338                       ENTRY XmitPacket 
0094 F338                       ENTRY stackrestore 
0095 F338                       ENTRY stacksave 
0096 F338
0097 F338
0098 F338              ;-------------------------------------------------------------------------------
0099 F338              ;                   General equates
0100 F338              ;-------------------------------------------------------------------------------
0101 F338
0102 F338              XBit     equ   $10
0103 F338              MBit     equ   $20
0104 F338              VBit     equ   $40
0105 F338              CBit     equ   $01
0106 F338              IBit     equ   $04
0107 F338
0108 F338              ZPStart  equ   $80
0109 F338              E1Start  equ   $1000
0110 F338              Base     equ   $E000                    ;Base of packet buffer area.
0111 F338
0112 F338              MID      equ   $0                       ;ID for Cortland.
0113 F338
0114 F338              lapzplen equ   $10
0115 F338              e1lapend equ   $001200                  ;really $e11200
0116 F338
0117 F338              atport   equ   $E101C0
0118 F338              atslot   equ   $E101C1
0119 F338              pmslot   equ   $E101C2
0120 F338
0121 F338              incbusyflag equ   $E10064               ;scheduler inc routine
0122 F338              decbusyflag equ   $E10068               ;Scheduler dec routine
0123 F338
0124 F338              rd80col  equ   $E1c018                  ;read 80 column switch
0125 F338              altsp    equ   $010101                  ;alt stack pointer
0126 F338              mainsp   equ   $010100                  ;main stack pointer
0127 F338              rdaltzp  equ   $C016                    ;read alt zero page switch
0128 F338
0129 F338              ;-------------------------------------------------------------------------------
0130 F338              ;                   SCC register definitions
0131 F338              ;-------------------------------------------------------------------------------
0132 F338
0133 F338              RecvIntsA equ   $20                     ;Mask to detect channel A recv ints.
0134 F338              RecvIntsB equ   $04                     ;Mask to detect channel B recv ints.
0135 F338              AddrReg  equ   $06
0136 F338              TxEmpty  equ   $04
0137 F338              RxAvail  equ   $01
0138 F338              Hunt     equ   $10
0139 F338              Underrun equ   $40
0140 F338              DisRx    equ   $D0
0141 F338              EnbRTS   equ   $E3
0142 F338              DisTxRTS equ   $E1
0143 F338              EnbTxRTS equ   $EB
0144 F338              ResTxCRC equ   $80
0145 F338              ResetUnd equ   $C0
0146 F338              ResetErr equ   $30
0147 F338              ReEnbInt equ   $20
0148 F338              EnbRxSlv equ   $CD
0149 F338              EnterHunt equ   $10
0150 F338              EnbRxInt equ   $08
0151 F338              SrchMode equ   $21
0152 F338              FMMode   equ   $C1
0153 F338              BaudRate equ   $06
0154 F338              ClocksA  equ   $F2
0155 F338              SetFM0   equ   $E0
0156 F338              SDLC     equ   $7E
0157 F338              EnbTx    equ   $E9
0158 F338              SDLCMode equ   $20
0159 F338              DisRxInt equ   $00
0160 F338              ResetA   equ   $8A
0161 F338              ResetB   equ   $4A
0162 F338
0163 F338              ;-------------------------------------------------------------------------------
0164 F338              ;                   Time definitions and equates
0165 F338              ;-------------------------------------------------------------------------------
0166 F338
0167 F338              TWLFree  equ   4000
0168 F338              T100usec equ   7
0169 F338              T2Flags  equ   28
0170 F338              TLastFlag equ   16
0171 F338              TAbort   equ   42
0172 F338              TIFGap   equ   100
0173 F338              TByte    equ   7
0174 F338
0175 F338              ;-------------------------------------------------------------------------------
0176 F338              ;                   LAP equates
0177 F338              ;-------------------------------------------------------------------------------
0178 F338
0179 F338              Broadcast equ   $FF
0180 F338              LAPEnq   equ   $81
0181 F338              LAPAck   equ   $82
0182 F338              LAPRTS   equ   $84
0183 F338              LAPCTS   equ   $85
0184 F338              DDPShort equ   1
0185 F338              DDPLong  equ   2
0186 F338              MaxData  equ   600                      ;Maximum amount of data in a LAP pkt.
0187 F338              MaxSize  equ   MaxData+11               ;Data + LAP + len + cksum + link + CRC.
0188 F338              GlobalSize equ   16
0189 F338              MaxColsns equ   32
0190 F338              MaxDefers equ   32
0191 F338
0192 F338              ;-------------------------------------------------------------------------------
0193 F338              ;                   Error equates
0194 F338              ;;-------------------------------------------------------------------------------
0195 F338
0196 F338              ColErr   equ   1
0197 F338              DefErr   equ   2
0198 F338              Err      equ   $80
0199 F338              CRCErr   equ   $40
0200 F338              ORunErr  equ   $20
0201 F338              TBigErr  equ   $10
0202 F338              TOutErr  equ   $8
0203 F338              Lock     equ   $1
0204 F338              NoErr    equ   0                        ;Success.
0205 F338              BufErr   equ   1                        ;No packet in buffer.
0206 F338              EndErr   equ   2                        ;End of buffer.
0207 F338              SizeErr  equ   3                        ;LAP data too large.
0208 F338              RetryErr equ   4                        ;Retry count exhausted.
0209 F338              IllProtErr equ   5                      ;Illegal protocol number (LAP type).
0210 F338              DupProtErr equ   6                      ;Duplicate protocol number.
0211 F338              FulProtErr equ   7                      ;Protocol list full.
0212 F338              MisProtErr equ   8                      ;Missing protocol (can't be removed).
0213 F338              ShortErr equ   9                        ;User's buffer is too short when purging
0214 F338              EnableErr equ   10                      ;AppleTalk is not enabled.
0215 F338              VBLSize  equ   12                       ;Size of ROM image of VBL entry.
0216 F338              MaxProts equ   8                        ;Maximum # of protocols in table.
0217 F338
0218 F338              ;-------------------------------------------------------------------------------
0219 F338              ;                   Misc. constants
0220 F338              ;-------------------------------------------------------------------------------
0221 F338
0222 F338
0223 F338              MVNOp    equ   $54
0224 F338              RTLOp    equ   $6B
0225 F338              NOPOp    equ   $EA
0226 F338              topstack equ   $1a0                     ;we want the stack this high
0227 F338
0228 F338              ;-------------------------------------------------------------------------------
0229 F338              ;                   Character constants
0230 F338              ;-------------------------------------------------------------------------------
0231 F338
0232 F338              CR       equ   $8D
0233 F338              LF       equ   $8A
0234 F338
0235 F338              irq_intflag equ   $C3
0236 F338              irq_secflag equ   $C6
0237 F338              irq_active equ   $CB
0238 F338              SCCStat  equ   $101
0239 F338              SCCFlag  equ   $102
0240 F338              SCCFlag2 equ   $103
0241 F338              SerFlag  equ   $104
0242 F338              scc1     equ   $105
0243 F338              scc2     equ   $106
0244 F338              irq_A    equ   $108
0245 F338              irq_X    equ   $10A
0246 F338              irq_Y    equ   $10C
0247 F338              irq_S    equ   $10E
0248 F338              irq_D    equ   $110
0249 F338              irq_DB   equ   $113
0250 F338              irq_State equ   $118
0251 F338              irq_shadow equ   $119
0252 F338              ;PORT1	equ	$2C0
0253 F338              ;PORT2	equ	$2CC
0254 F338              ;USERSLT1	equ	$2E1	;We don't use these two anymore.
0255 F338              ;USERSLT7	equ	$2E7
0256 F338
0257 F338              ;-------------------------------------------------------------------------------
0258 F338              ;                   Hardwired locations
0259 F338              ;-------------------------------------------------------------------------------
0260 F338
0261 F338              LapDest  equ   $D000
0262 F338              ThisNet  equ   $D010
0263 F338              ABridge  equ   $D013
0264 F338              LCBank2  equ   $C083
0265 F338              RDROM    equ   $C082
0266 F338              CYAReg   equ   $C036
0267 F338              StateReg equ   $C068
0268 F338              SCCBReg  equ   $C038
0269 F338              SCCAReg  equ   $C039
0270 F338              MouseA   equ   $C044
0271 F338              MouseB   equ   $C045
0272 F338              mouseMode equ   $C041
0273 F338              CLRVBLINT equ   $C047
0274 F338
0275 F338              ;-------------------------------------------------------------------------------
0276 F338              ;                   Call block definition equates
0277 F338              ;-------------------------------------------------------------------------------
0278 F338
0279 F338              lp_async equ   0                        ;General
0280 F338              lp_command equ   lp_async+1
0281 F338              lp_result equ   lp_command+1
0282 F338              li_flag  equ   lp_result+2              ;LAPInit
0283 F338              li_entry equ   li_flag+1
0284 F338              li_node  equ   li_entry+4               ;2 for entry, 2 reserved.
0285 F338              li_size  equ   li_node+1
0286 F338              gi_return equ   lp_result+2             ;GetInfo
0287 F338              gi_net   equ   gi_return+4
0288 F338              gi_bridge equ   gi_net+2
0289 F338              gi_mid   equ   gi_bridge+1
0290 F338              gi_version equ   gi_mid+1
0291 F338              gi_size  equ   gi_version+1
0292 F338              gg_buffer equ   lp_result+2             ;GetGlobal
0293 F338              ggb_length equ   $10
0294 F338              lw_dest  equ   lp_result+2              ;LAPWrite
0295 F338              lw_lapType equ   lw_dest+1
0296 F338              lw_BDS   equ   lw_lapType+1
0297 F338              lw_size  equ   lw_BDS+4
0298 F338              lr_count equ   lp_result+2              ;LAPRead
0299 F338              lr_buffer equ   lr_count+2
0300 F338              lr_purge equ   lr_buffer+4
0301 F338              lr_actual equ   lr_purge+1
0302 F338              lr_size  equ   lr_actual+2
0303 F338              ap_prot  equ   lp_result+2              ;AttachProtocol
0304 F338              ap_handler equ   ap_prot+1
0305 F338              ap_size  equ   ap_handler+4
0306 F338              rm_prot  equ   lp_result+2              ;RemoveProtocol
0307 F338              rm_size  equ   rm_prot+1
0308 F338
0309 F338              ;-------------------------------------------------------------------------------
0310 F338              ;                   Receive buffer data structure offsets:
0311 F338              ;-------------------------------------------------------------------------------
0312 F338
0313 F338              buf_next equ   0
0314 F338              buf_len  equ   buf_next+2
0315 F338              buf_cksum equ   buf_len+2
0316 F338              buf_lap  equ   buf_cksum+2
0317 F338              buf_dest equ   buf_lap
0318 F338              buf_src  equ   buf_dest+1
0319 F338              buf_type equ   buf_src+1
0320 F338              buf_data equ   buf_type+1
0321 F338
0322 F338              ;-------------------------------------------------------------------------------
0323 F338              ;                   Zero page usage.
0324 F338              ;-------------------------------------------------------------------------------
0325 F338
0326 F338              cmndList equ   ZPStart                  ;General
0327 F338              zpCurBuf equ   cmndList
0328 F338              execAddr equ   cmndList+4
0329 F338
0330 F338              sccReg   equ   execAddr+4               ;SCC pointers
0331 F338              sccDat   equ   sccReg+2
0332 F338              ptr0     equ   sccDat+2
0333 F338              ptr1     equ   ptr0+3
0334 F338              r0       equ   ptr1+3
0335 F338              r1       equ   r0+1
0336 F338              r2       equ   r1+1
0337 F338              r3       equ   r2+1
0338 F338              ZPEnd    equ   r3+1
0339 F338              ZPSize   equ   ZPEnd-ZPStart
0340 F338
0341 F338              ;-------------------------------------------------------------------------------
0342 F338              ;                   Bank E1 variables.
0343 F338              ;-------------------------------------------------------------------------------
0344 F338
0345 F338              Extended equ   E1Start                  ;RAM vectors.  Extended interface entry.
0346 F338              Basic    equ   Extended+4               ;Basic entry.
0347 F338              Pascal   equ   Basic+4                  ;Pascal entry.
0348 F338              RamGoComp equ   Pascal+4                ;users gocomp entry for completions
0349 F338              SoftReset equ   RamGoComp+4             ;Soft reset chain.
0350 F338              RamDispatch equ   SoftReset+4           ;Command dispatcher.
0351 F338              RamForbid equ   RamDispatch+4           ;RAM vector to long entry of forbid.
0352 F338              RamPermit equ   RamForbid+4             ;For Permit.
0353 F338              ProEntry equ   RamPermit+4              ;Original ProDOS entry point.
0354 F338              Prodos   equ   ProEntry+2               ;Prodos entry.
0355 F338              SerStatus equ   Prodos+4                ;Serial interface status hook
0356 F338              SerWrite equ   SerStatus+4              ;" " write hook.
0357 F338              SerRead  equ   SerWrite+4               ;For Read.
0358 F338              SerBackgnd equ   SerRead+4              ;For background printing.
0359 F338              PDispatch equ   SerBackgnd+4            ;For dispatching packets.
0360 F338              ExtraVec equ   PDispatch+4              ;For more vectors.
0361 F338
0362 F338              colHist  equ   ExtraVec+20              ;These first  variables need to be set
0363 F338              defHist  equ   colHist+1                ;to zero at initialization, so put them
0364 F338              gBackOff equ   defHist+1                ;together.
0365 F338              needData equ   gBackOff+1
0366 F338              addrValid equ   needData+1
0367 F338              busyFlag equ   addrValid+1
0368 F338              pktError equ   busyFlag+1
0369 F338              deltaT   equ   pktError+1
0370 F338              trailing equ   deltaT+1
0371 F338              curPos   equ   trailing+1
0372 F338              catchProt equ   curPos+2
0373 F338              protTable equ   catchProt+4             ;This table must be filled with $ff's.
0374 F338              whichMouse equ   protTable+MaxProts*6
0375 F338              seed     equ   whichMouse+2
0376 F338              addrUsed equ   seed+2
0377 F338              gotCTS   equ   addrUsed+1
0378 F338              gotData  equ   gotCTS+1
0379 F338              dest     equ   gotData+1
0380 F338              source   equ   dest+1
0381 F338              lapType  equ   source+1
0382 F338              lBackOff equ   lapType+1
0383 F338              colTries equ   lBackOff+1
0384 F338              defTries equ   colTries+1
0385 F338              errRec   equ   defTries+1
0386 F338              txBDS    equ   errRec+2
0387 F338              whichSCC equ   txBDS+4
0388 F338              ckSum    equ   whichSCC+2
0389 F338              freeProt equ   ckSum+2
0390 F338              scc1A    equ   freeProt+2
0391 F338              scc2A    equ   scc1A+1
0392 F338              scc3     equ   scc2A+1
0393 F338              curRBuf  equ   scc3+1
0394 F338              curLen   equ   curRBuf+2
0395 F338              curWBuf  equ   curLen+2
0396 F338              curOffset equ   curWBuf+2
0397 F338              curEnd   equ   curOffset+2
0398 F338              ourstacksave equ   curEnd+3
0399 F338              stksaveflag equ   ourstacksave+(topstack-$ff) ;only reserve space to save from $100 up to topstack
0400 F338              stretaddr equ   stksaveflag+2
0401 F338              lentosave equ   stretaddr+2
0402 F338              oldstack equ   lentosave+2
0403 F338              stacksavea equ   oldstack+2
0404 F338              stacksavex equ   stacksavea+2
0405 F338              stacksavey equ   stacksavex+2
0406 F338              stacksaveb equ   stacksavey+2
0407 F338              stacksavep equ   stacksaveb+2
0408 F338              nestedflag equ   stacksavep+2
0409 F338              dstack   equ   nestedflag+2
0410 F338              dstate   equ   dstack+2
0411 F338              E1End    equ   dstate+1
0412 F338              zzz      equ   E1End                    ;Note the last byte used should
0413 F338                                                      ;not be beyond $e11200
0414 F338
0415 F338              ;-------------------------------------------------------------------------------
0416 F338              ;                   Slot 7 equates
0417 F338              ;-------------------------------------------------------------------------------
0418 F338
0419 F338              ;C7xx	equ	$C7A0	;emulation mode entry
0420 F338              ;C7xxGo	equ	$C7A1	;native mode entry
0421 F338              ;C7xxRet	equ	$C7A8	;return point for routines
0422 F338              ;C7Error	equ	$C7AB	;error point for pascal not installed
0423 F338              ;C7Prodos	equ	$C7AE	;bank 0 entry for prodos
0424 F338
0425 F338              OfstCnxx equ   $A0                      ;emulation mode entry
0426 F338              OfstCnxxGo equ   $A1                    ;native mode entry
0427 F338              OfstCnxxRet equ   $A8                   ;return point for routines
0428 F338              OfstCnError equ   $AB                   ;error point for pascal not installed
0429 F338              OfstCnProdos equ   $AE                  ;bank 0 entry for prodos
0430 F338
0431 F338              Cnxx     equ   $E11042                  ;emulation mode entry
0432 F338              CnxxGo   equ   $E11046                  ;native mode entry
0433 F338              OnExitVector equ   $E1104A              ;Exit vector for QTRIRQ
0434 F338
0435 F338              ;_______________________________________________________________________________
0436 F338
0437 F338              LapExit  PROC 
0438 F338
0439 F338 28                    plp                            ;Get back mode (must be full native).
0440 F339                       longa on
0441 F339 29 FF 00              and   #$ff                     ;Mask off high byte.
0442 F33C F0 06                 beq   NolErr                   ;If successful, leave high byte alone.
0443 F33E 09 00 02              ora   #$200                    ;Otherwise, make it a LAP error.
0444 F341 80 01                 bra   NolErr
0445 F343
0446 F343                       entry LAPExit2                 ; EXPORT -> ENTRY  **TGH
0447 F343              LAPExit2                                ;
0448 F343 28                    plp   
0449 F344              NolErr                                  ;
0450 F344 A0 02 00              ldy   #lp_result               ;Point to the LAP result field.
0451 F347 97 80                 sta   [cmndList],y             ;Store result. A MUST contain the
0452 F349                       longa off                      ;result when we exit!!!! Don't change
0453 F349 6B                    rtl                            ;or you will die.
0454 F34A
0455 F34A                       ENDP 
0456 F34A
0457 F34A              ****************************************************************
0458 F34A              *
0459 F34A              *  'LAPWrite' can be called only with a parameter list.
0460 F34A              *
0461 F34A              ****************************************************************
0462 F34A              *
0463 F34A              LAPWrite PROC EXPORT 
0464 F34A
0465 F34A 20 B8 F9              jsr   EnterCrit
0466 F34D 08                    php   
0467 F34E A0 06 00              ldy   #lw_bds                  ;Get low word of BDS pointer.
0468 F351 B7 80                 lda   [cmndList],y
0469 F353 8D 9C 10              sta   txBDS                    ;Store it for XmitPacket.
0470 F356 C8                    iny                            ;Point to high word.
0471 F357 C8                    iny   
0472 F358 B7 80                 lda   [cmndList],y             ;Get high word.
0473 F35A 8D 9E 10              sta   txBDS+2                  ;Store for XmitPacket.
0474 F35D E2 20                 sep   #MBit                    ;8 bit A.
0475 F35F A0 04 00              ldy   #lw_dest                 ;Now get the destination for the write.
0476 F362 B7 80                 lda   [cmndList],y
0477 F364 8D 94 10              sta   dest                     ;Store it.
0478 F367 A0 05 00              ldy   #lw_lapType              ;Get the LAP type.
0479 F36A B7 80                 lda   [cmndList],y
0480 F36C F0 0E                 beq   @L1                      ;LAPTypes of 0 or
0481 F36E 30 0C                 bmi   @L1                      ; > 127 are illegal!
0482 F370 8D 96 10              sta   lapType                  ;Store it.
0483 F373 20 53 FB              jsr   XmitPacket
0484 F376 20 E0 F9              jsr   ExitCrit
0485 F379 4C 38 F3     @L2      jmp   LAPExit                  ;Return, storing A in the result code.
0486 F37C
0487 F37C A9 05        @L1      lda   #IllProtErr              ;Illegal LAP type.
0488 F37E 80 F9                 bra   @L2
0489 F380
0490 F380                       ENDP 
0491 F380
0492 F380              ****************************************************************
0493 F380              *
0494 F380              *  'GetInfo' must be called with a parameter list.
0495 F380              *
0496 F380              *  Inputs:
0497 F380              *
0498 F380              *  Outputs:
0499 F380              *
0500 F380              ****************************************************************
0501 F380              *
0502 F380              * GWS 2/10/88 - the paramater list has been expanded to support
0503 F380              * the return of the node number and an extra byte for the romversion
0504 F380              *
0505 F380              ****************************************************************
0506 F380
0507 F380              GetInfo  PROC EXPORT 
0508 F380
0509 F380 08                    php   
0510 F381                       longa on
0511 F381
0512 F381 A0 04 00              ldy   #gi_return
0513 F384 AF 43 10 E1           lda   Cnxx+1                   ;Plus 1 to get to bank byte of vector
0514 F388 29 00 FF              and   #$FF00
0515 F38B 09 A8 00              ora   #OfstCnxxRet             ;ORA in the Cnxx offset for addr of
0516 F38E 97 80                 sta   [cmndList],y             ;socket listeners, protocol handlers,
0517 F390 A9 00 00              lda   #0                       ;and completion routines.
0518 F393 C8                    iny                            ;Move to high word of return address.
0519 F394 C8                    iny   
0520 F395 97 80                 sta   [cmndList],y             ;Set to bank zero.
0521 F397
0522 F397 C8                    iny   
0523 F398 C8                    iny                            ;Move on to network field.
0524 F399 AD 10 D0              lda   ThisNet                  ;Get our network #.
0525 F39C 97 80                 sta   [cmndList],y             ;Store in list (byte reversed...)
0526 F39E
0527 F39E C8                    iny   
0528 F39F C8                    iny                            ;Move to bridge field.
0529 F3A0 AD 13 D0              lda   ABridge                  ;Get node # of a bridge, any bridge.
0530 F3A3 97 80                 sta   [cmndList],y
0531 F3A5
0532 F3A5 C8                    iny                            ;Move to machine ID and ROM version #.
0533 F3A6 A9 00 00              lda   #MID                     ;Get ONE bytes of info!  **TGH
0534 F3A9              *	lda	#MID+256*RomVer	;Get two bytes of info.  **TGH
0535 F3A9 97 80                 sta   [cmndList],y
0536 F3AB
0537 F3AB C8                    iny                            ;now store rom id as a word (GWS 5/20/88)
0538 F3AC A9 20 10              lda   #RomVer                  ;This used to look at C7FE like it
0539 F3AF                                                      ;should, but I can't tell if it's in
0540 F3AF                                                      ;C1FE or C2FE so I just hard coded what's
0541 F3AF                                                      ;there, figuring CnFE won't change without
0542 F3AF                                                      ;changing RomVer in this code.
0543 F3AF 97 80                 sta   [cmndlist],y
0544 F3B1
0545 F3B1 AD 95 10              lda   source                   ;get our node number (GWS 2/10/88)
0546 F3B4 29 FF 00              and   #$00ff                   ;set high byte to zero
0547 F3B7 C8                    iny   
0548 F3B8 C8                    iny                            ;move to high byte of romver field
0549 F3B9 E2 20                 sep   #mbit                    ;store a byte for node
0550 F3BB 97 80                 sta   [cmndlist],y             ;save it
0551 F3BD
0552 F3BD C2 20                 rep   #mbit
0553 F3BF A9 00 00              lda   #0                       ;No error.
0554 F3C2 4C 38 F3              jmp   LAPExit
0555 F3C5
0556 F3C5                       longa off
0557 F3C5                       ENDP 
0558 F3C5              ****************************************************************
0559 F3C5              *
0560 F3C5              *  'LAPInit' can be called with either a parameter list or parameters in
0561 F3C5              *  registers.  If C is set, registers are used.
0562 F3C5              *  When registers are used, there are no parameters.
0563 F3C5              *
0564 F3C5              *  Inputs:  A = starting node number.
0565 F3C5              *
0566 F3C5              *  Outputs: A = node number chosen.
0567 F3C5              *
0568 F3C5              ****************************************************************
0569 F3C5
0570 F3C5              LAPInit  PROC EXPORT 
0571 F3C5
0572 F3C5 08                    php   
0573 F3C6 E2 20                 sep   #MBit                    ;8 bit A.
0574 F3C8 C2 10                 rep   #XBit                    ;16 bit index.
0575 F3CA B0 22                 bcs   Direct                   ;This way if direct mode.
0576 F3CC A0 04 00              ldy   #li_flag                 ;See which kind of init to do.
0577 F3CF B7 80                 lda   [cmndList],y
0578 F3D1 10 16                 bpl   NotFull                  ;If bit 7 reset, not a full init.
0579 F3D3 A0 09 00              ldy   #li_node                 ;Get the node number to start with.
0580 F3D6 5A                    phy                            ;Save pointer to li_node.
0581 F3D7 B7 80                 lda   [cmndList],y
0582 F3D9 38                    sec                            ;Now use direct mode.
0583 F3DA 20 C5 F3              jsr   LAPInit
0584 F3DD 09 00                 ora   #0
0585 F3DF D0 05                 bne   OK
0586 F3E1 A9 0A                 lda   #EnableErr               ;AppleTalk not enabled.
0587 F3E3 7A                    ply   
0588 F3E4 80 05                 bra   Exit
0589 F3E6              OK                                      ; 
0590 F3E6 7A                    ply   
0591 F3E7 97 80                 sta   [cmndList],y             ;Store the node actually picked.
0592 F3E9              NotFull                                 ; 
0593 F3E9 A9 00                 lda   #0
0594 F3EB              Exit                                    ; 
0595 F3EB 4C 38 F3              jmp   LapExit                  ;Stores result in param list.
0596 F3EE              Direct                                  ;
0597 F3EE
0598 F3EE              ; We no longer check to see if appletalk is in slot 7.  We only check if appletalk
0599 F3EE              ; is in slot 1 or slot 2.
0600 F3EE              ;
0601 F3EE              ;	pha		;Save node number.
0602 F3EE              ;	lda	USERSLT7	;Check to see if AppleTalk is enabled.
0603 F3EE              ;	beq	GoAhead	;Yes, it's enabled.
0604 F3EE              ;	pla		;Get back node #.
0605 F3EE              ;	lda	#0	;Error: AppleTalk not enabled.
0606 F3EE              ;	plp
0607 F3EE              ;	rts
0608 F3EE
0609 F3EE 48                    pha                            ;Save node number.
0610 F3EF
0611 F3EF A2 38 C0              ldx   #SCCBReg                 ;Assume AppleTalk is port B.
0612 F3F2 A0 45 C0              ldy   #MouseB                  ;Get pointer to line activity counter.
0613 F3F5 A9 04                 lda   #RecvIntsB               ;Interrupt mask for port B ATalk.
0614 F3F7 48                    pha                            ;Save on stack for later.
0615 F3F8 A9 4A                 lda   #ResetB                  ;Channel B reset code.
0616 F3FA 48                    pha                            ;Save on stack.
0617 F3FB
0618 F3FB AF C0 01 E1           lda   atport
0619 F3FF C9 02                 cmp   #$02
0620 F401 F0 15                 beq   UsePortB
0621 F403 C9 01                 cmp   #$01
0622 F405 F0 07                 beq   UsePortA
0623 F407
0624 F407 68                    pla                            ;Oops, AppleTalk not enabled!
0625 F408 68                    pla                            ;Strip interupt mask, reset code,
0626 F409 68                    pla                            ;and node number of the stack.
0627 F40A A9 00                 lda   #0
0628 F40C 28                    plp   
0629 F40D 60                    rts   
0630 F40E
0631 F40E              ;GoAhead		; 
0632 F40E              ;	ldx	#SCCBReg	;Assume AppleTalk is port B.
0633 F40E              ;	ldy	#MouseB	;Get pointer to line activity counter.
0634 F40E              ;	lda	#RecvIntsB	;Interrupt mask for port B ATalk.
0635 F40E              ;	pha		;Save on stack for later.
0636 F40E              ;	lda	#ResetB	;Channel B reset code.
0637 F40E              ;	pha		;Save on stack.
0638 F40E              ;	lda	USERSLT1	;Which port is AppleTalk in?
0639 F40E              ;	beq	UsePortB	;0: A is serial, so ATalk is B.
0640 F40E              ;	inx		;1: move ahead to serial port A.
0641 F40E              ;	dey		;Move back to channel A activity port.
0642 F40E              ;	lda	#RecvIntsA	;Interrupt mask for port A ATalk.
0643 F40E              ;	sta	2,s	;Replace interrupt mask on stack.
0644 F40E              ;	lda	#ResetA	;Channel A reset code.
0645 F40E              ;	sta	1,s
0646 F40E
0647 F40E E8           UsePortA inx                            ;1: move ahead to serial port A.
0648 F40F 88                    dey                            ;Move back to channel A activity port.
0649 F410 A9 20                 lda   #RecvIntsA               ;Interrupt mask for port A ATalk.
0650 F412 83 02                 sta   2,s                      ;Replace interrupt mask on stack.
0651 F414 A9 8A                 lda   #ResetA                  ;Channel A reset code.
0652 F416 83 01                 sta   1,s
0653 F418
0654 F418 8E A0 10     UsePortB stx   whichSCC
0655 F41B 8C 8D 10              sty   whichMouse
0656 F41E 86 88                 stx   sccReg                   ;Control register pointer.
0657 F420 E8                    inx   
0658 F421 E8                    inx   
0659 F422 86 8A                 stx   sccDat                   ;Data register pointer.
0660 F424 08                    php                            ;Push mode and disable ints.
0661 F425 78                    sei   
0662 F426 A9 00                 lda   #0                       ;Send synch byte to SCC.
0663 F428 92 88                 sta   (sccReg)
0664 F42A A9 09                 lda   #9                       ;Point to reset register.
0665 F42C 92 88                 sta   (sccReg)
0666 F42E A3 02                 lda   2,s                      ;Get back SCC reset code for our port.
0667 F430 92 88                 sta   (sccReg)                 ;Reset the port.
0668 F432 28                    plp                            ;Restore mode and fix stack.
0669 F433 68                    pla   
0670 F434
0671 F434              * Initialize variables with 0, fill protTable with $ff.
0672 F434 08                    php                            ;Save mode.
0673 F435 C2 20                 rep   #MBit                    ;16 bit A for MVN.
0674 F437                       longa on
0675 F437 9C 4E 10              stz   colHist                  ;Clear the first byte of vars that
0676 F43A A2 4E 10              ldx   #colHist                 ;must be zero.  Point to that byte
0677 F43D 9B                    txy                            ;and use as source for MVN.
0678 F43E C8                    iny                            ;Use next address as dest for MVN.
0679 F43F A9 0E 00              lda   #14                      ;Number of bytes to clear - 1.
0680 F442 54 E1 E1              mvn   $e1e1e1,$e1e1e1          ;Clear the bytes.
0681 F445 CE 5D 10              dec   protTable                ;Change the first byte of protTable to
0682 F448 A9 2E 00              lda   #MaxProts*6-2            ;$ff, and fill the table with that
0683 F44B 54 E1 E1              mvn   $e1e1e1,$e1e1e1          ;value.
0684 F44E              * GWS 6/8/88
0685 F44E              * moved initialzation of variables related
0686 F44E              * to stack save routines
0687 F44E              * into the lapresetinit routine, so they
0688 F44E              * would be set up properly before ever
0689 F44E              * going through the dispatcher.
0690 F44E              *
0691 F44E              * Now initialize the SCC for AppleTalk mode.
0692 F44E                       longa off
0693 F44E                       longi off
0694 F44E E2 34                 sep   #MBit+XBit+IBit          ;8 bits and disable interrupts.
0695 F450 A2 00                 ldx   #0                       ;Point to first byte.
0696 F452 A0 1E                 ldy   #SCCTabSize              ;Get size of table.
0697 F454              InitLoop                                ; 
0698 F454 BF 2D F5 FD           lda   >SCCTable,x              ;Get a byte at a time to initialize the
0699 F458 92 88                 sta   (sccReg)                 ;SCC for AppleTalk mode.
0700 F45A E8                    inx                            ;On to next byte.
0701 F45B 88                    dey   
0702 F45C D0 F6                 bne   InitLoop
0703 F45E 28                    plp                            ;Restore mode.
0704 F45F                       longi on
0705 F45F 20 BA FD              jsr   RecvInit
0706 F462
0707 F462              * Now init packet buffer maintenance variables.
0708 F462 A2 63 E2              ldx   #Base+MaxSize            ;Set up initial 'curEnd' value to
0709 F465 8E B1 10              stx   curEnd                   ;point to the end of the first
0710 F468 A9 E0                 lda   #$E0                     ;packet buffer in the bank E1 language
0711 F46A 8D B3 10              sta   curEnd+2                 ;card space (E0 + offset ---> E1).
0712 F46D A2 00 E0              ldx   #Base                    ;Set up the pointer to the beginning of
0713 F470 8E AD 10              stx   curWBuf                  ;the first write buffer.
0714 F473 8E A9 10              stx   curRBuf                  ;Also the read buffer.
0715 F476 C2 20                 rep   #MBit
0716 F478                       longa on
0717 F478 9E 00 00              stz   |buf_next,x              ;Clear curRBuf->next.
0718 F47B A2 A6 FD              ldx   #-(MaxData+2)            ;Set up offset to point to the start of
0719 F47E 8E AF 10              stx   curOffset                ;the LAP data field.
0720 F481
0721 F481              * Now set up interrupt vectors.
0722 F481 4B                    phk   
0723 F482 4B                    phk   
0724 F483 68                    pla                            ;Get high byte of vector address in A.
0725 F484 29 FF 00              and   #$ff                     ;Mask off high byte.
0726 F487
0727 F487 F4 00 00              pea   0                        ;This signals the end of the calls.
0728 F48A
0729 F48A F4 04 00              pea   4                        ;Now enable the quarter sec interrupt.
0730 F48D F4 03 23              pea   $2303                    ;IntSource tool number.
0731 F490
0732 F490 F4 08 00              pea   8                        ;Install AppleTalk interrupt vector.
0733 F493 48                    pha                            ;Push bank of vector.
0734 F494 F4 F9 F7              pea   PacketIRQ                ;Low Word of address.
0735 F497 A2 03 10              ldx   #$1003                   ;SetVector tool number.
0736 F49A DA                    phx                            ;Put on stack for below.
0737 F49B
0738 F49B F4 0E 00              pea   14                       ;Install quarter sec interrupt handler.
0739 F49E 48                    pha                            ;Push bank word of vector.
0740 F49F F4 23 F9              pea   QtrSecIRQ                ;Low word of address.
0741 F4A2
0742 F4A2              ToolLoop                                ; 
0743 F4A2 22 00 00 E1           jsl   $E10000                  ;Make a call.
0744 F4A6 FA                    plx                            ;Get the next tool call number.
0745 F4A7 D0 F9                 bne   ToolLoop                 ;If not zero, do another call.
0746 F4A9
0747 F4A9 E2 20                 sep   #MBit                    ;8 bit A.
0748 F4AB                       longa off
0749 F4AB 68                    pla                            ;Get back AppleTalk interrupt mask.
0750 F4AC 8D 03 01              sta   SCCFlag2                 ;Store it in the right spot.
0751 F4AF 68                    pla                            ;Get back node number.
0752 F4B0 F0 04                 beq   specialnd                ;get workstation random node using battery
0753 F4B2 C9 FF                 cmp   #$ff                     ;see if server random wanted
0754 F4B4 D0 1C                 bne   NotZ                     ;they want to specify start node
0755 F4B6              specialnd                               ; 
0756 F4B6 48                    pha                            ;save node mask
0757 F4B7 C2 30                 rep   #MBit+XBit               ;from battery RAM. Full native for
0758 F4B9 F4 00 00              pea   0                        ;tool call.  Space for result.
0759 F4BC F4 80 00              pea   $80                      ;Parameter value for node #.
0760 F4BF A2 03 0C              ldx   #$0C03                   ;ReadBParam tool call number.
0761 F4C2 22 00 00 E1           jsl   $E10000                  ;Do the call.
0762 F4C6 68                    pla                            ;Get the result.
0763 F4C7 E2 30                 sep   #MBit+xbit               ;8 bit A. and X
0764 F4C9 FA                    plx                            ;get node flag
0765 F4CA 30 04                 bmi   specialsrv
0766 F4CC 29 7F                 and   #$7f                     ;put in workstation range
0767 F4CE 80 02                 bra   NotZ
0768 F4D0              specialsrv                              ; 
0769 F4D0 09 80                 ora   #$80                     ;must have high bit on
0770 F4D2              NotZ                                    ; 
0771 F4D2 C2 10                 rep   #xbit                    ;back to 16 bit x
0772 F4D4
0773 F4D4              ***************************************************************
0774 F4D4              *
0775 F4D4              *  'NewNode' tries to find an unclaimed node number on the network.  If the
0776 F4D4              *  value passed in A is 0, it picks a random non-server node number and
0777 F4D4              *  increments it until it has found an address.  If A holds $ff, a random
0778 F4D4              *  server node number is picked and incremented until an address has been found.
0779 F4D4              *  Any other number in A is used as the first attempt and similarly incremented
0780 F4D4              *  until an address is found.
0781 F4D4              *
0782 F4D4              *  Inputs:  A = 0 for randomly assigned non-server node (1..127).
0783 F4D4              *           A = 255 for randomly assigned server node (128..254).
0784 F4D4              *           A = n for randomly assigned node, using 'n' to start the search.
0785 F4D4              *
0786 F4D4              *  Outputs: A,X trashed.
0787 F4D4              *           'source' holds the node we picked.
0788 F4D4              *
0789 F4D4              ****************************************************************
0790 F4D4              *
0791 F4D4              NewNode                                 ; 
0792 F4D4 9C 52 10              stz   addrValid
0793 F4D7 A2 7F 00              ldx   #127                     ;X is the number of nodes to try.
0794 F4DA 1A                    inc   A                        ;Check for 255.
0795 F4DB D0 0F                 bne   NNNotServer              ;If not 255, check for 0.
0796 F4DD 20 B3 F5              jsr   Random                   ;Get a random number.
0797 F4E0 AD 90 10              lda   seed+1
0798 F4E3 09 80                 ora   #128                     ;Make it a server node.
0799 F4E5 C9 FF                 cmp   #255                     ;Illegal?
0800 F4E7 D0 11                 bne   NNTryNode                ;No. Try it.
0801 F4E9 3A                    dec   A                        ;Back up to a legal value.
0802 F4EA 80 0E                 bra   NNTryNode                ;Try it.
0803 F4EC              NNNotServer                             ; 
0804 F4EC 3A                    dec   A                        ;Now check for 0.
0805 F4ED D0 0B                 bne   NNTryNode                ;If not 0, use as a starting node num.
0806 F4EF 20 B3 F5              jsr   Random                   ;If 0, get a random byte
0807 F4F2 AD 90 10              lda   seed+1
0808 F4F5 29 7F                 and   #127                     ;and turn it into a non-server node.
0809 F4F7 D0 01                 bne   NNTryNode                ;If not zero, try it.
0810 F4F9 1A                    inc   A                        ;Otherwise, inc to 1.
0811 F4FA              NNTryNode                               ; 
0812 F4FA DA                    phx   
0813 F4FB 48                    pha   
0814 F4FC 20 7F F5              jsr   TryNode                  ;See if anyone else has this node.
0815 F4FF 68                    pla   
0816 F500 FA                    plx   
0817 F501 B0 14                 bcs   NNNextNode               ;Carry set -> node taken, try next one.
0818 F503 8D 52 10              sta   addrValid                ;Node unclaimed: set the 'addrValid'
0819 F506 C2 30                 rep   #MBit+XBit               ;flag, store node # in battery RAM. Full
0820 F508 48                    pha                            ;native for tool call. Put node # on
0821 F509 48                    pha                            ;stack, and again for later.
0822 F50A F4 80 00              pea   $80                      ;Parameter value for node #.
0823 F50D A2 03 0B              ldx   #$0B03                   ;WriteBParam tool call number.
0824 F510 22 00 00 E1           jsl   $E10000                  ;Do the call.
0825 F514 68                    pla                            ;Get back the node #.
0826 F515 28                    plp                            ;Restore mode and return with
0827 F516 60                    rts                            ;the node in A.
0828 F517
0829 F517              NNNextNode                              ; 
0830 F517 1A                    inc   A                        ;Try next node number.
0831 F518 C9 FF                 cmp   #255                     ;Check for invalid server node number.
0832 F51A D0 04                 bne   NNNot255                 ;Nope.
0833 F51C A9 80                 lda   #128                     ;Restart with the next valid server.
0834 F51E 80 06                 bra   NNCheckDone              ;See if done yet.
0835 F520              NNNot255                                ; 
0836 F520 C9 80                 cmp   #128                     ;Check for invalid non-server node.
0837 F522 D0 02                 bne   NNCheckDone              ;Nope.
0838 F524 A9 01                 lda   #1                       ;Restart with the next valid node.
0839 F526              NNCheckDone                             ; 
0840 F526 CA                    dex                            ;See if we've tried all 127 nodes.
0841 F527 D0 D1                 bne   NNTryNode                ;X <> 0 --> not done, try this node.
0842 F529 A9 FF                 lda   #$FF                     ;Tried 128 times, but didn't get a
0843 F52B 28                    plp                            ;node.  Return $FF.
0844 F52C 60                    rts   
0845 F52D
0846 F52D              SCCTable                                ; 
0847 F52D 01 00                 DC B:1,DisRxInt                ;Disable receiver interrupts.
0848 F52F 0F 00                 DC B:15,0                      ;No external interrupts.
0849 F531 04 20                 DC B:4,SDLCMode                ;Set SDLC mode.
0850 F533 03 D0                 DC B:3,DisRx                   ;Disable receiver.
0851 F535 05 E9                 DC B:5,EnbTx                   ;Enable transmitter.
0852 F537 C0                    DC B:ResetUnd                  ;Reset underrun latch.
0853 F538 80                    DC B:ResTxCRC                  ;Reset transmit CRC.
0854 F539 05 E1                 DC B:5,DisTxRTS                ;Disable transmitter.
0855 F53B 07 7E                 DC B:7,SDLC                    ;Set SDLC flag pattern.
0856 F53D 0A E0                 DC B:10,SetFM0                 ;Set FM0 transmission.
0857 F53F 0B F2                 DC B:11,ClocksA                ;Set clock usage.
0858 F541 0C 06                 DC B:12,BaudRate               ;Low byte of baud rate.
0859 F543 0D 00                 DC B:13,0                      ;High byte of baud rate.
0860 F545 0E C1                 DC B:14,FMMode                 ;Set FM mode on phase locked loop.
0861 F547 0E 21                 DC B:14,SrchMode               ;Set search mode on phase locked loop.
0862 F549 01 08                 DC B:1,EnbRxInt                ;Enable first character interrupts.
0863 F54B              SCCTabEnd                               ; 
0864 F54B              SCCTabSize equ   SCCTabEnd-SCCTable
0865 F54B
0866 F54B
0867 F54B              * lapresetinit
0868 F54B              *
0869 F54B              * code to be called to make sure that we start
0870 F54B              * off pointing to no packets, so we won't have
0871 F54B              * to worry about anyone calling the dispatch
0872 F54B              * routines indirectly before appletalk gets
0873 F54B              * initialized
0874 F54B              * this routine is called during either a hard
0875 F54B              * or soft reset.
0876 F54B              * we also initialize some variables that are
0877 F54B              * used by stack saving routines, since these
0878 F54B              * routines get called by the dispatcher, we
0879 F54B              * had better make sure they are set up properly
0880 F54B              *
0881 F54B                       EXPORT lapresetinit 
0882 F54B              lapresetinit                            ;
0883 F54B
0884 F54B              * Now init packet buffer maintenance variables.
0885 F54B
0886 F54B 08                    php   
0887 F54C C2 10                 rep   #xbit
0888 F54E                       longi on
0889 F54E E2 20                 sep   #mbit
0890 F550                       longa off
0891 F550 A2 63 E2              ldx   #Base+MaxSize            ;Set up initial 'curEnd' value to
0892 F553 8E B1 10              stx   curEnd                   ;point to the end of the first
0893 F556 A9 E0                 lda   #$E0                     ;packet buffer in the bank E1 language
0894 F558 8D B3 10              sta   curEnd+2                 ;card space (E0 + offset ---> E1).
0895 F55B A2 00 E0              ldx   #Base                    ;Set up the pointer to the beginning of
0896 F55E 8E AD 10              stx   curWBuf                  ;the first write buffer.
0897 F561 8E A9 10              stx   curRBuf                  ;Also the read buffer.
0898 F564 C2 20                 rep   #MBit
0899 F566                       longa on
0900 F566 9E 00 00              stz   |buf_next,x              ;Clear curRBuf->next.
0901 F569 A2 A6 FD              ldx   #-(MaxData+2)            ;Set up offset to point to the start of
0902 F56C 8E AF 10              stx   curOffset                ;the LAP data field.
0903 F56F 9C 55 11              stz   stksaveflag              ;Clear the first byte of vars that
0904 F572 A2 55 11              ldx   #stksaveflag             ;must be zero.  Point to that byte
0905 F575 9B                    txy                            ;and use as source for MVN.
0906 F576 C8                    iny                            ;Use next address as dest for MVN.
0907 F577 A9 16 00              lda   #(E1End-stksaveflag)-1   ;Number of bytes to clear - 1.
0908 F57A 54 E1 E1              mvn   $e1e1e1,$e1e1e1          ;Clear the bytes.
0909 F57D 28                    plp   
0910 F57E 60                    rts                            ;and return
0911 F57F
0912 F57F                       ENDP 
0913 F57F
0914 F57F              ****************************************************************
0915 F57F              *
0916 F57F              *  'TryNode' checks to see if the node number passed in A is occupied by
0917 F57F              *  another node on the network.
0918 F57F              *
0919 F57F              *  Inputs:
0920 F57F              *
0921 F57F              *  Outputs: A,X trashed.
0922 F57F              *           C flag cleared for node free, set for node in use.
0923 F57F              *
0924 F57F              ****************************************************************
0925 F57F
0926 F57F              TryNode  PROC 
0927 F57F
0928 F57F                       longa off
0929 F57F                       longi on
0930 F57F A2 78 00              ldx   #120                     ;Assume it's a server: use large
0931 F582 09 00                 ora   #0                       ;maxtries.  Check it out...
0932 F584 30 03                 bmi   Server                   ;Yes, it is.
0933 F586 A2 14 00              ldx   #20                      ;No, it's not.  Use small maxtries.
0934 F589              Server                                  ; 
0935 F589 8D 94 10              sta   dest                     ;Use A as our dest address as well as
0936 F58C 8D 95 10              sta   source                   ;our node address.
0937 F58F 08                    php                            ;Save mode.
0938 F590 48                    pha                            ;Save node # on stack.
0939 F591 78                    sei                            ;Turn off ints while accessing SCC.
0940 F592 A9 06                 lda   #AddrReg                 ;Point to the address register.
0941 F594 92 88                 sta   (sccReg)
0942 F596 68                    pla                            ;Get back node number.
0943 F597 92 88                 sta   (sccReg)                 ;Use for SCC's address.
0944 F599 28                    plp                            ;Restore mode.
0945 F59A A9 81                 lda   #LAPEnq                  ;Set LAP type to Enq.
0946 F59C 8D 96 10              sta   lapType
0947 F59F 9C 91 10              stz   addrUsed                 ;Assume not used.
0948 F5A2              TNLoop                                  ; 
0949 F5A2 DA                    phx                            ;Save X.
0950 F5A3 20 53 FB              jsr   XmitPacket               ;Transmit the Enq, detect response.
0951 F5A6 FA                    plx                            ;Restore X.
0952 F5A7 AD 91 10              lda   addrUsed                 ;See if any packets came to this
0953 F5AA F0 02                 beq   NotClaimed               ;address.  If so, the address is used.
0954 F5AC 38                    sec                            ;Set carry and return, indicating
0955 F5AD 60                    rts                            ;that the address is used.
0956 F5AE              NotClaimed                              ; 
0957 F5AE CA                    dex                            ;If not claimed after maxtries,
0958 F5AF D0 F1                 bne   TNLoop                   ;we believe that this address is truly
0959 F5B1 18                    clc                            ;free.  Clear carry and return.
0960 F5B2 60                    rts   
0961 F5B3                       ENDP 
0962 F5B3
0963 F5B3              ****************************************************************
0964 F5B3              *
0965 F5B3              *  'Random' uses the number in 'seed' as a base for a new random number,
0966 F5B3              *  which replaces 'seed'.
0967 F5B3              *
0968 F5B3              *  Inputs:
0969 F5B3              *
0970 F5B3              *  Outputs:
0971 F5B3              *
0972 F5B3              ****************************************************************
0973 F5B3
0974 F5B3              Random   PROC 
0975 F5B3
0976 F5B3 08                    php                            ;Save mode.
0977 F5B4 C2 20                 rep   #MBit                    ;16 bit A.
0978 F5B6                       longa on
0979 F5B6 AD 8E 10              lda   seed-1                   ;Get seed * 256 + garbage.
0980 F5B9 29 00 FF              and   #$ff00                   ;mask off the garbage.
0981 F5BC 48                    pha                            ;Save seed * 256.
0982 F5BD 0A                    asl   A                        ;A = seed * 512.
0983 F5BE 18                    clc   
0984 F5BF 63 01                 adc   1,S                      ;A = seed * 768.
0985 F5C1 18                    clc   
0986 F5C2 6D 8F 10              adc   seed                     ;A = seed * 769.
0987 F5C5 83 01                 sta   1,S                      ;Save seed * 769.
0988 F5C7 AD 8F 10              lda   seed                     ;A = seed.
0989 F5CA 0A                    asl   A                        ;A = seed * 2.
0990 F5CB 0A                    asl   A                        ;A = seed * 4.
0991 F5CC 18                    clc   
0992 F5CD 63 01                 adc   1,S                      ;A = seed * 773.
0993 F5CF 1A                    inc   A                        ;A = seed * 773 + 1.
0994 F5D0 8D 8F 10              sta   seed                     ;Update seed.
0995 F5D3 68                    pla                            ;Fix stack.
0996 F5D4 28                    plp                            ;Restore mode.
0997 F5D5 60                    rts   
0998 F5D6
0999 F5D6                       longa off
1000 F5D6                       ENDP 
1001 F5D6              ****************************************************************
1002 F5D6              *
1003 F5D6              *  'LAPRead'
1004 F5D6              *  'LAPRead' can be called with either a parameter list or parameters in
1005 F5D6              *  registers.  If C is set, registers are used.
1006 F5D6              *
1007 F5D6              *  Inputs:  X,Y = pointer to data buffer (Y = high word).
1008 F5D6              *           A = # of bytes to read (16 bit A).  Bit 15 is the purge bit: if set,
1009 F5D6              *           the buffer will be removed from the buffer list.
1010 F5D6              *
1011 F5D6              *  Outputs: A = result code, X = number of bytes actually read.
1012 F5D6              *
1013 F5D6              ****************************************************************
1014 F5D6
1015 F5D6              LAPRead  PROC EXPORT 
1016 F5D6
1017 F5D6 08                    php   
1018 F5D7 B0 31                 bcs   ILAPRead                 ;Go do direct call.
1019 F5D9 A0 06 00              ldy   #lr_buffer               ;Get the buffer address.
1020 F5DC B7 80                 lda   [cmndList],y
1021 F5DE AA                    tax                            ;Put low word of address in X.
1022 F5DF C8                    iny                            ;Move to high word.
1023 F5E0 C8                    iny   
1024 F5E1 B7 80                 lda   [cmndList],y             ;Get high word.
1025 F5E3 48                    pha                            ;Save on stack.
1026 F5E4 A0 04 00              ldy   #lr_count                ;Get the requested byte count.
1027 F5E7 B7 80                 lda   [cmndList],y
1028 F5E9 48                    pha                            ;Save byte count on stack.
1029 F5EA A0 0A 00              ldy   #lr_purge                ;Get purge flag.
1030 F5ED B7 80                 lda   [cmndList],y
1031 F5EF                       longa on
1032 F5EF 29 FF 00              and   #$ff                     ;Ignore high byte.
1033 F5F2 F0 03                 beq   NotSet                   ;Flag is not set, A is 0.
1034 F5F4 A9 00 80              lda   #$8000                   ;Set purge flag.
1035 F5F7              NotSet                                  ; 
1036 F5F7 03 01                 ora   1,s                      ;OR byte count with purge flag (bit 15).
1037 F5F9 7A                    ply                            ;Remove byte count from stack.
1038 F5FA 7A                    ply                            ;Get high word of address in Y.
1039 F5FB 38                    sec                            ;Now do direct call.
1040 F5FC 20 D6 F5              jsr   LAPRead                  ;Do the call.
1041 F5FF 48                    pha                            ;Save the result.
1042 F600 8A                    txa                            ;Get back # of bytes read in A.
1043 F601 A0 0B 00              ldy   #lr_actual               ;Get offset to field for number read.
1044 F604 97 80                 sta   [cmndList],y
1045 F606 68                    pla                            ;Get back result.
1046 F607 4C 38 F3              jmp   LAPExit                  ;Save the result, return.
1047 F60A              ****************************************************************
1048 F60A              *
1049 F60A              *  'ILAPRead' reads the number of bytes specified by A into the buffer
1050 F60A              *  pointed to by X and Y (Y = high word).  The result code is returned in A.
1051 F60A              *
1052 F60A              *  Possible results:
1053 F60A              *           NoErr: Read successful.
1054 F60A              *           EndErr: Reached the end of the buffer before reading the number of
1055 F60A              *                   bytes specified.
1056 F60A              *           BufErr: No packet buffer.
1057 F60A              *
1058 F60A              *  Inputs:  X,Y points to buffer (Y high word), A specifies # of bytes to read.
1059 F60A              *           16 bit A, 16 bit X.  Data bank = $E1.
1060 F60A              *
1061 F60A              *  Outputs: A = result code, X = number of bytes actually read.
1062 F60A              *
1063 F60A              ****************************************************************
1064 F60A              *
1065 F60A              ILAPRead                                ; 
1066 F60A 20 B8 F9              jsr   EnterCrit
1067 F60D C2 30                 rep   #MBit+XBit
1068 F60F                       longa on
1069 F60F              MVNAddr  equ   $84
1070 F60F 48                    pha                            ;Store purge bit and count.
1071 F610 AD 57 10              lda   curPos                   ;Is there a buffer open?
1072 F613 D0 08                 bne   IsBuf                    ;Yes.
1073 F615 A9 01 00              lda   #BufErr                  ;No: report error.
1074 F618 FA                    plx                            ;Remove stuff from stack.
1075 F619 28                    plp                            ;Get back mode.
1076 F61A 4C E0 F9              jmp   ExitCrit                 ;Return through ExitCrit.
1077 F61D              IsBuf                                   ; 
1078 F61D 68                    pla                            ;Get back the count.
1079 F61E F4 00 00              pea   0                        ;Assume no error, push error code.
1080 F621 48                    pha                            ;Save count.
1081 F622 29 FF 7F              and   #$7fff                   ;Mask off the purge bit.
1082 F625 48                    pha                            ;Store the count.
1083 F626 AD AB 10              lda   curLen                   ;See if there are enough bytes in the
1084 F629 C3 01                 cmp   1,s                      ;buffer to satisfy the requested count.
1085 F62B B0 09                 bcs   Enough                   ;Yes.
1086 F62D 83 01                 sta   1,s                      ;No: use the number available instead
1087 F62F A9 02 00              lda   #EndErr                  ;of that specified and indicate error.
1088 F632 83 05                 sta   5,s                      ;Store in error loc.
1089 F634 80 0B                 bra   Exact
1090 F636              Enough                                  ; 
1091 F636 F0 09                 beq   Exact                    ;Exactly the right length!
1092 F638 A3 03                 lda   3,s                      ;See if purging.
1093 F63A 10 05                 bpl   Exact                    ;No: ignore if buffer is 'too small.'
1094 F63C A9 09 00              lda   #ShortErr                ;Otherwise, the buffer is too short.
1095 F63F 83 05                 sta   5,s
1096 F641              Exact                                   ; 
1097 F641 8A                    txa                            ;Move low dest address to a for boundry check
1098 F642 18                    clc   
1099 F643 63 01                 adc   1,s                      ;add to count to see if bank wrap would happen
1100 F645 90 2E                 bcc   domvn                    ;no, so lets use MVN code for speed
1101 F647 A3 01                 lda   1,s                      ;get count
1102 F649 F0 45                 beq   Zero                     ;nothing to move
1103 F64B 86 84                 stx   MVNAddr                  ;Store low word of destination address
1104 F64D 84 86                 sty   MVNAddr+2                ;Store high word of destination address
1105 F64F A8                    tay                            ;use as index and counter
1106 F650 18                    clc   
1107 F651 5A                    phy                            ;use to calculate offset
1108 F652 AD 57 10              lda   curPos                   ;get start of buffer
1109 F655 63 01                 adc   1,s                      ;move to end position
1110 F657 FA                    plx                            ;discard stack stuff
1111 F658 AA                    tax                            ;move index to x register (points to last char)
1112 F659 98                    tya                            ;get index for odd test
1113 F65A 4A                    lsr   a                        ;see if number of bytes to move is odd
1114 F65B 90 0B                 bcc   lapmovelp                ;go ahead and move 2 bytes at a pop
1115 F65D 88                    dey                            ;only do one byte to get us on an even keel
1116 F65E CA                    dex   
1117 F65F E2 20                 sep   #mbit
1118 F661 BD 00 00              lda   |0,x                     ;get the source byte
1119 F664 97 84                 sta   [mvnaddr],y              ;and store the odd byte
1120 F666 C2 20                 rep   #mbit                    ;back to 16 bit accum
1121 F668              lapmovelp                               ; ;should always be working with even number of bytes
1122 F668 88                    dey                            ;when we get this far.
1123 F669 88                    dey                            ;back up counter
1124 F66A 30 24                 bmi   Zero                     ;we are done when this is less than zero
1125 F66C CA                    dex   
1126 F66D CA                    dex                            ;and source position
1127 F66E BD 00 00              lda   |0,x                     ;get 2 source bytes
1128 F671 97 84                 sta   [mvnaddr],y              ;and move them
1129 F673 80 F3                 bra   lapmovelp                ;go do more
1130 F675              domvn                                   ; 
1131 F675 A9 54 00              lda   #MVNOp                   ;Set up a move instruction in ZP.
1132 F678 85 84                 sta   MVNAddr
1133 F67A 84 85                 sty   MVNAddr+1                ;Put dest bank from Y in ZP, then source
1134 F67C A9 E1 6B              lda   #$E1+256*RTLOp           ;bank ($e1), then RTL instruction.
1135 F67F 85 86                 sta   MVNAddr+2
1136 F681 9B                    txy                            ;Move low dest address to Y for MVN.
1137 F682 AE 57 10              ldx   curPos                   ;Move low src address to X for MVN.
1138 F685 A3 01                 lda   1,s                      ;Get the count.
1139 F687 F0 07                 beq   Zero
1140 F689 3A                    dec   A                        ;Adjust the count.
1141 F68A 8B                    phb                            ;Save bank on stack.
1142 F68B 22 84 00 00           jsl   >MVNAddr                 ;Do the move.
1143 F68F AB                    plb                            ;Get it back.
1144 F690              Zero                                    ; 
1145 F690 AD AB 10              lda   curLen                   ;Modify the length of the rest of the
1146 F693 38                    sec                            ;packet.
1147 F694 E3 01                 sbc   1,s                      ;Subtract the number of bytes read.
1148 F696 8D AB 10              sta   curLen                   ;Store it.
1149 F699 AD 57 10              lda   curPos                   ;Also modify the current read position.
1150 F69C 18                    clc   
1151 F69D 63 01                 adc   1,s                      ;Add the number of bytes read.
1152 F69F 8D 57 10              sta   curPos
1153 F6A2 FA                    plx                            ;Get back count.
1154 F6A3 68                    pla                            ;Get back purge bit.
1155 F6A4 10 0C                 bpl   NoPurge                  ;Don't purge.
1156 F6A6 9C 57 10              stz   curPos                   ;Purge: no buffer anymore.
1157 F6A9 DA                    phx                            ;Save count during freebuf.
1158 F6AA E2 20                 sep   #MBit                    ;8 bit A for freebuf.
1159 F6AC 20 51 FE              jsr   FreeBuf                  ;Purge the buffer.
1160 F6AF C2 20                 rep   #MBit                    ;Back to 16 bits.
1161 F6B1 FA                    plx                            ;Get back count.
1162 F6B2              NoPurge                                 ; 
1163 F6B2 68                    pla                            ;Get back result.
1164 F6B3 28                    plp                            ;Restore mode.
1165 F6B4 4C E0 F9              jmp   ExitCrit                 ;Return through ExitCrit.
1166 F6B7                       longa off
1167 F6B7                       ENDP 
1168 F6B7
1169 F6B7              ****************************************************************
1170 F6B7              *
1171 F6B7              *  'GetGlobal' must be called with a parameter list.
1172 F6B7              *
1173 F6B7              ****************************************************************
1174 F6B7              *
1175 F6B7              * GWS 2/10/88 - fixed bug where we would hang if you called this
1176 F6B7              * before actually receiving any data.
1177 F6B7              *
1178 F6B7              ****************************************************************
1179 F6B7
1180 F6B7              GetGlobal PROC EXPORT 
1181 F6B7
1182 F6B7 08                    php   
1183 F6B8                       longa on
1184 F6B8                       longi on
1185 F6B8 AD 57 10              lda   curpos                   ;see if anything valid has been received
1186 F6BB D0 06                 bne   getglobok                ;there is something to read (GWS 2/10/88)
1187 F6BD A9 01 02              lda   #$200+buferr             ;we got a buffer error
1188 F6C0 4C 43 F3              jmp   LapExit2                 ;get out of here
1189 F6C3              getglobok                               ; 
1190 F6C3 A0 04 00              ldy   #gg_buffer               ;Get the buffer address.
1191 F6C6 B7 80                 lda   [cmndList],y
1192 F6C8 AA                    tax                            ;Put low word of address in X.
1193 F6C9 C8                    iny                            ;Move to high word.
1194 F6CA C8                    iny   
1195 F6CB B7 80                 lda   [cmndList],y             ;Get high word.
1196 F6CD A8                    tay                            ;Put high word of address in Y.
1197 F6CE              ****************************************************************
1198 F6CE              *
1199 F6CE              *  'IGetGlobal' reads the first 16 bytes of the packet, including the LAP
1200 F6CE              *  header, into the buffer pointed to by X,Y (Y = high word).  The result code
1201 F6CE              *  is returned in A, and the number of bytes actually read is returned in X.
1202 F6CE              *
1203 F6CE              *  Possible results:
1204 F6CE              *           NoErr: Read successful.
1205 F6CE              *           BufErr: No packet buffer.
1206 F6CE              *           EndErr: Reached the end of the buffer before reading 16 bytes.
1207 F6CE              *
1208 F6CE              *  Inputs:  X,Y points to buffer (Y high word).
1209 F6CE              *           16 bit A, 16 bit X.  Data bank = $E1.
1210 F6CE              *
1211 F6CE              *  Outputs: A = result code, X = number of bytes actually read.
1212 F6CE              *
1213 F6CE              ****************************************************************
1214 F6CE              *
1215 F6CE              IGetGlobal                              ; 
1216 F6CE 20 B8 F9              jsr   EnterCrit
1217 F6D1                       longa on
1218 F6D1 86 84                 stx   execaddr
1219 F6D3 84 86                 sty   execaddr+2               ;set up pointer to users buffer
1220 F6D5 AE A9 10              ldx   curRBuf                  ;Get pointer to the actual buffer.
1221 F6D8 BD 02 00              lda   |buf_len,x               ;Get the length of the packet.
1222 F6DB 69 03 00              adc   #3                       ;Add 3 for the LAP header.
1223 F6DE A0 10 00              ldy   #ggb_length              ;offset to length part of users buffer
1224 F6E1 97 84                 sta   [execaddr],y
1225 F6E3              ggmove                                  ; ;needs y to be set to length field offset
1226 F6E3 88                    dey   
1227 F6E4 88                    dey   
1228 F6E5 30 07                 bmi   ggmovedone               ;we are done moving data
1229 F6E7 B9 00 D0              lda   |lapdest,y               ;get data to move
1230 F6EA 97 84                 sta   [execaddr],y             ;move the data to the users buffer
1231 F6EC 80 F5                 bra   ggmove                   ;and move some more
1232 F6EE              ggmovedone                              ; 
1233 F6EE A9 00 00              lda   #0                       ;no error
1234 F6F1              NotErr                                  ; 
1235 F6F1 20 E0 F9              jsr   ExitCrit
1236 F6F4 4C 43 F3              jmp   LAPExit2
1237 F6F7                       longa off
1238 F6F7
1239 F6F7                       ENDP 
1240 F6F7
1241 F6F7              ****************************************************************
1242 F6F7              *
1243 F6F7              *  'AttachProt' can be called with either a parameter list or parameters in
1244 F6F7              *  registers.  If C is set, registers are used.
1245 F6F7              *
1246 F6F7              *  Inputs:  A = the protocol number, X,Y = handler address (Y = high word).
1247 F6F7              *
1248 F6F7              *  Outputs: A = result.
1249 F6F7              *
1250 F6F7              ****************************************************************
1251 F6F7
1252 F6F7              AttachProt PROC EXPORT 
1253 F6F7
1254 F6F7                       EXPORT lattachprot 
1255 F6F7              lattachprot                             ;
1256 F6F7
1257 F6F7 08                    php   
1258 F6F8 B0 18                 bcs   IAttachProt              ;Go do direct call.
1259 F6FA A0 05 00              ldy   #ap_handler              ;Get the handler address.
1260 F6FD B7 80                 lda   [cmndList],y
1261 F6FF AA                    tax                            ;X gets low address word.
1262 F700 C8                    iny                            ;Move to the high word.
1263 F701 C8                    iny   
1264 F702 B7 80                 lda   [cmndList],y             ;Get high address word.
1265 F704 48                    pha                            ;Save on stack.
1266 F705 A0 04 00              ldy   #ap_prot                 ;Get the protocol type.
1267 F708 B7 80                 lda   [cmndList],y
1268 F70A 7A                    ply                            ;Y gets high address word.
1269 F70B 38                    sec                            ;Direct call.
1270 F70C 20 F7 F6              jsr   AttachProt               ;Do the call.
1271 F70F 4C 38 F3              jmp   LAPExit                  ;Exit, setting result.
1272 F712              IAttachProt                             ; 
1273 F712 E2 20                 sep   #MBit
1274 F714 DA                    phx   
1275 F715 5A                    phy   
1276 F716 20 B8 F9              jsr   EnterCrit                ;Critical code portion.
1277 F719 C9 FF                 cmp   #$FF                     ;Is it the catch all protocol handler?
1278 F71B D0 14                 bne   NotCatch
1279 F71D AE 59 10              ldx   catchProt
1280 F720 D0 3B                 bne   IsDup                    ;If a catch-all is installed, duplicate
1281 F722 AE 5B 10              ldx   catchProt+2
1282 F725 D0 36                 bne   IsDup                    ;Ditto.
1283 F727 7A                    ply                            ;Otherwise, we can install as catch-all
1284 F728 8C 5B 10              sty   catchProt+2              ;handler.
1285 F72B FA                    plx   
1286 F72C 8E 59 10              stx   catchProt
1287 F72F 80 25                 bra   ExitOK
1288 F731              NotCatch                                ;
1289 F731 20 63 F7              jsr   FindProt                 ;See if the protocol is already there.
1290 F734 B0 27                 bcs   IsDup                    ;If so, error.
1291 F736 AE A4 10              ldx   freeProt                 ;Did FindProt find a free protocol
1292 F739 10 04                 bpl   NotFull                  ;slot?  If positive, yes.
1293 F73B A9 07                 lda   #FulProtErr              ;Negative: protocol list full.
1294 F73D 80 20                 bra   Error
1295 F73F              NotFull                                 ; 
1296 F73F 09 00                 ora   #0
1297 F741 F0 02                 beq   Illegal                  ;If 0, illegal.
1298 F743 10 04                 bpl   Legal                    ;If < $80, legal.
1299 F745              Illegal                                 ; 
1300 F745 A9 05                 lda   #IllProtErr              ;Otherwise, illegal protocol type.
1301 F747 80 16                 bra   Error
1302 F749              Legal                                   ; 
1303 F749 9D 5D 10              sta   |protTable,X             ;Store the prot #.
1304 F74C C2 20                 rep   #MBit                    ;16 bit A.
1305 F74E 68                    pla                            ;Get high word of handler address.
1306 F74F 9D 7D 10              sta   |protTable+4*MaxProts,X  ;Store in the entry.
1307 F752 68                    pla                            ;Get low word of address.
1308 F753 9D 6D 10              sta   |protTable+2*MaxProts,X  ;Store it.
1309 F756              ExitOK                                  ; 
1310 F756                       longa on                       ;Not always true, but we use a NOP to
1311 F756 A9 00 EA              lda   #NOPOp*256               ;make things OK.  Clears low byte for
1312 F759                       longa off                      ;successful result code.
1313 F759              Exit                                    ; 
1314 F759 28                    plp   
1315 F75A 4C E0 F9              jmp   ExitCrit                 ;No longer critical, and return.
1316 F75D              IsDup                                   ; 
1317 F75D A9 06                 lda   #DupProtErr              ;Else, return duplicate error.
1318 F75F              Error                                   ; 
1319 F75F 7A                    ply   
1320 F760 FA                    plx   
1321 F761 80 F6                 bra   Exit
1322 F763                       ENDP 
1323 F763
1324 F763              ****************************************************************
1325 F763              *
1326 F763              *  'FindProt' sees if the protocol # passed in A has a handler in the table.
1327 F763              *  If so, a pointer to the table entry is in X and C = 1.  If not, 'freeProt'
1328 F763              *  is set to point to a free entry in the table (or $ffff if none) and C = 0.
1329 F763              *
1330 F763              *  Inputs:
1331 F763              *
1332 F763              *  Outputs:
1333 F763              *
1334 F763              ****************************************************************
1335 F763
1336 F763              FindProt PROC 
1337 F763
1338 F763 A0 FF FF              ldy   #$ffff                   ;Assume that no free slot can be   
1339 F766 A2 10 00              ldx   #MaxProts*2              ;found.  Point to past end of table.
1340 F769              FPLoop2                                 ; 
1341 F769 8C A4 10              sty   freeProt
1342 F76C              FPLoop                                  ; 
1343 F76C CA                    dex   
1344 F76D CA                    dex   
1345 F76E 10 02                 bpl   NotEnd                   ;If +, not at end of table.
1346 F770 18                    clc                            ;Otherwise, clear C to indicate
1347 F771 60                    rts                            ;entry not found and return.
1348 F772              NotEnd                                  ; 
1349 F772 DD 5D 10              cmp   |protTable,x             ;See if this is the protocol.
1350 F775 D0 02                 bne   NotThis
1351 F777 38                    sec                            ;This is the one.  Set C to indicate
1352 F778 60                    rts                            ;we found it and return.
1353 F779              NotThis                                 ; 
1354 F779 BC 5C 10              ldy   |protTable-1,x           ;Get entry's prot type in high byte.
1355 F77C 10 EE                 bpl   FPLoop                   ;If not minus, it's not free, so loop.
1356 F77E 9B                    txy                            ;Else record a free slot's position.
1357 F77F 80 E8                 bra   FPLoop2
1358 F781                       ENDP 
1359 F781
1360 F781              ****************************************************************
1361 F781              *
1362 F781              *  'RemoveProt' can be called only with parameter list.
1363 F781              *
1364 F781              ****************************************************************
1365 F781
1366 F781              RemoveProt PROC EXPORT 
1367 F781
1368 F781 08                    php   
1369 F782 E2 20                 sep   #MBit                    ;8 bit A.
1370 F784 A0 04 00              ldy   #rm_prot                 ;Get the protocol to remove.
1371 F787 B7 80                 lda   [cmndList],y
1372 F789 20 B8 F9              jsr   EnterCrit                ;Enter critical section.
1373 F78C C9 FF                 cmp   #$FF                     ;See if it's the catch-all protocol.
1374 F78E D0 16                 bne   NotCatch
1375 F790 AE 59 10              ldx   catchProt                ;Is there a catch-all protocol handler
1376 F793 D0 05                 bne   OK                       ;installed? Yes, can remove it.
1377 F795 AE 5B 10              ldx   catchProt+2
1378 F798 F0 17                 beq   Missing                  ;Not installed: can't remove it.
1379 F79A              OK                                      ; 
1380 F79A A2 00 00              ldx   #0                       ;Clear the catch all handler.
1381 F79D 8E 59 10              stx   catchProt
1382 F7A0 8E 5B 10              stx   catchProt+2
1383 F7A3 8A                    txa                            ;0 result code for success.
1384 F7A4 80 19                 bra   Exit
1385 F7A6              NotCatch                                ; 
1386 F7A6 C9 00                 cmp   #00                      ;see if illegal type
1387 F7A8 F0 0B                 beq   Rillegal                 ;yes, so report error
1388 F7AA 30 09                 bmi   Rillegal                 ;also bad if negative
1389 F7AC 20 63 F7              jsr   FindProt                 ;See if we can find this protocol.
1390 F7AF B0 08                 bcs   Found                    ;Yes: maybe remove it.
1391 F7B1              Missing                                 ; 
1392 F7B1 A9 08                 lda   #MisProtErr              ;Protocol is missing, so can't remove
1393 F7B3 80 0A                 bra   Exit                     ;it. Return.
1394 F7B5 A9 05        Rillegal lda   #IllProtErr              ;illegal protocol type
1395 F7B7 80 06                 bra   Exit
1396 F7B9              Found                                   ; 
1397 F7B9 A9 FF                 lda   #$ff                     ;If not, it can be removed from the
1398 F7BB 9D 5D 10              sta   |protTable,x             ;table by making its slot empty.
1399 F7BE 1A                    inc   A                        ;Inc to successful result code (0).
1400 F7BF              Exit                                    ; 
1401 F7BF 20 E0 F9              jsr   ExitCrit                 ;No more critical code: return.
1402 F7C2 4C 38 F3              jmp   LAPExit                  ;Go back.
1403 F7C5                       ENDP 
1404 F7C5
1405 F7C5
1406 F7C5              Save16   PROC 
1407 F7C5 08                    php   
1408 F7C6 C2 30                 rep   #MBit+XBit
1409 F7C8                       longa on
1410 F7C8 DA                    phx                            ;We save X only.
1411 F7C9 A2 80 00              ldx   #cmndList                ;Save ZP space.
1412 F7CC A9 10 00              lda   #16                      ;Save 16 bytes.
1413 F7CF 20 4B E5              jsr   SaveZP
1414 F7D2 FA                    plx                            ;Get back X.
1415 F7D3 28                    plp   
1416 F7D4 60                    rts   
1417 F7D5                       longa off
1418 F7D5                       ENDP 
1419 F7D5
1420 F7D5              Restore16 PROC 
1421 F7D5 08                    php   
1422 F7D6 C2 30                 rep   #MBit+XBit
1423 F7D8                       longa on
1424 F7D8 DA                    phx                            ;We save X only.
1425 F7D9 A0 80 00              ldy   #cmndList                ;Restore ZP space.
1426 F7DC A9 10 00              lda   #16                      ;Restore 16 bytes.
1427 F7DF 20 72 E5              jsr   RestoreZP
1428 F7E2 FA                    plx                            ;Get back X.
1429 F7E3 28                    plp   
1430 F7E4 60                    rts   
1431 F7E5                       longa off
1432 F7E5                       ENDP 
1433 F7E5
1434 F7E5              GetBank  PROC 
1435 F7E5 AD 68 C0              lda   StateReg
1436 F7E8 7A                    ply                            ;Get return address.
1437 F7E9 48                    pha                            ;Save memory state.
1438 F7EA 5A                    phy                            ;Put return address back.
1439 F7EB AD 83 C0              lda   LCBank2                  ;Read language card RAM.
1440 F7EE AD 83 C0              lda   LCBank2                  ;Also write it.
1441 F7F1 60                    rts   
1442 F7F2                       ENDP 
1443 F7F2
1444 F7F2              UnGetBank PROC 
1445 F7F2 7A                    ply                            ;Get return address.
1446 F7F3 68                    pla                            ;Get previous memory state.
1447 F7F4 8D 68 C0              sta   StateReg
1448 F7F7 5A                    phy   
1449 F7F8 60                    rts   
1450 F7F9                       ENDP 
1451 F7F9
1452 F7F9              ****************************************************************
1453 F7F9              *
1454 F7F9              *  'PacketIRQ' handles packet interrupts.
1455 F7F9              *
1456 F7F9              *  Inputs:
1457 F7F9              *
1458 F7F9              *  Outputs:
1459 F7F9              *
1460 F7F9              ****************************************************************
1461 F7F9              *
1462 F7F9              * GWS - 2/10/88 - we no longer accept packets when our buffer
1463 F7F9              * space is full, before we accepted the packet and threw it away
1464 F7F9              * this also fixes, by default, the problem we had where we didn't 
1465 F7F9              * set the needData flag back to zero in all cases.
1466 F7F9              *
1467 F7F9              ****************************************************************
1468 F7F9
1469 F7F9              PacketIRQ PROC 
1470 F7F9
1471 F7F9 C2 10                 rep   #XBit                    ;16 bit indexes.
1472 F7FB AE A0 10              ldx   whichSCC                 ;Get pointer to current SCC port.
1473 F7FE BD 02 00              lda   |2,X                     ;Get the 3rd data byte, which has been
1474 F801 8D A8 10              sta   scc3                     ;waiting for us, and save it.
1475 F804 20 E5 F7              jsr   GetBank                  ;Save StateReg, change to LC bank 2.
1476 F807 20 C5 F7              jsr   Save16                   ;Save 16 bytes of ZP on private stack.
1477 F80A 86 88                 stx   sccReg                   ;Store address of control register.
1478 F80C E8                    inx   
1479 F80D E8                    inx   
1480 F80E 86 8A                 stx   sccDat                   ;Store address of data register.
1481 F810 9C 54 10              stz   pktError                 ;No receive errors (yet).
1482 F813 AD A8 10              lda   scc3                     ;Look at LAP type: if it's not a LAP
1483 F816 30 03                 bmi   LAPPkt                   ;control packet, ignore it and exit.
1484 F818              ExitBranch                              ; 
1485 F818 4C 8D F8              jmp   ExitPktIRQ
1486 F81B              LAPPkt                                  ; 
1487 F81B 38                    sec                            ;Indicate single byte mode to RecvBytes.
1488 F81C 20 F2 FA              jsr   RecvBytes                ;Get first byte of CRC.
1489 F81F 90 F7                 bcc   ExitBranch               ;C = 0 means last byte. Error, so exit.
1490 F821 20 F2 FA              jsr   RecvBytes                ;Get second byte of CRC.
1491 F824 B0 F2                 bcs   ExitBranch               ;Not last byte. Error, so exit.
1492 F826 AD 54 10              lda   pktError                 ;See if any errors occured during
1493 F829 30 ED                 bmi   ExitBranch               ;reception.  Yes, exit.
1494 F82B EE 05 01              inc   scc1                     ;Look at dest address.
1495 F82E F0 03                 beq   BCast                    ;If it's not broadcast,
1496 F830 8D 91 10              sta   addrUsed                 ;show activity on our address.
1497 F833              BCast                                   ; 
1498 F833 AD 52 10              lda   addrValid                ;If our address isn't valid,
1499 F836 F0 E0                 beq   ExitBranch               ;exit.
1500 F838 AD A8 10              lda   scc3                     ;No errors. Look at the LAP type.
1501 F83B C9 84                 cmp   #LAPRTS                  ;Is it a request to send?
1502 F83D D0 40                 bne   NotRTS                   ;No.
1503 F83F AC AF 10              ldy   curOffset                ;Get offset to current buffer (GWS 2/10/88)
1504 F842 F0 D4                 beq   ExitBranch               ;buffer is empty so don't send CTS
1505 F844 AE B1 10              ldx   curEnd                   ;Set ptr0 = curEnd.
1506 F847 86 8C                 stx   ptr0
1507 F849 AE B3 10              ldx   curEnd+2
1508 F84C 86 8E                 stx   ptr0+2
1509 F84E EE 51 10              inc   needData                 ;Indicate that we need a data packet.
1510 F851 9C 93 10              stz   gotData                  ;No data yet.
1511 F854 AD 05 01              lda   scc1                     ;See if broadcast.
1512 F857 D0 05                 bne   DoCTS                    ;If not, do a CTS.
1513 F859 20 BA FD              jsr   RecvInit                 ;Otherwise, init the receiver for the
1514 F85C 80 08                 bra   GetData                  ;data packet and try to receive.
1515 F85E              DoCTS                                   ; 
1516 F85E AE 06 01              ldx   scc2                     ;Get source of the RTS and use it as
1517 F861 A9 85                 lda   #LAPCTS                  ;the dest for a CTS packet.
1518 F863 20 77 FC              jsr   fXmitLAP                 ;Send the CTS (without sync) and init the receiver.
1519 F866              GetData                                 ; 
1520 F866 AC AF 10              ldy   curOffset                ;Get offset of current buffer.
1521 F869 20 52 FA              jsr   RecvPacket               ;Try to receive the data packet.
1522 F86C 9C 51 10              stz   needData                 ;Back to normal mode. (should always get here after inc above)
1523 F86F AD 93 10              lda   gotData                  ;See if we got the data.
1524 F872 F0 1C                 beq   ExitNoInit               ;Nope.
1525 F874 20 CC FD              jsr   NewPacket                ;Yep.  Add the packet to the list.
1526 F877              TryDispatch                             ; 
1527 F877 AD 53 10              lda   busyFlag                 ;See if higher level protocols are busy.
1528 F87A D0 14                 bne   ExitNoInit               ;Busy, so don't try to dispatch a pkt.
1529 F87C
1530 F87C 20 A7 F8              jsr   dothedispatch
1531 F87F
1532 F87F              NotRTS                                  ; 
1533 F87F C9 81                 cmp   #LAPEnq                  ;Is it an enquiry?
1534 F881 D0 0A                 bne   ExitPktIRQ               ;No.  We don't handle it.
1535 F883 AE 06 01              ldx   scc2                     ;Get source of the Enq and use it as
1536 F886 A9 82                 lda   #LAPAck                  ;the dest for an Ack packet.
1537 F888 20 77 FC              jsr   fXmitLAP                 ;Send the Ack (without sync) and init the receiver
1538 F88B 80 03                 bra   ExitNoInit               ;and exit.
1539 F88D
1540 F88D              ExitPktIRQ                              ; 
1541 F88D 20 BA FD              jsr   RecvInit                 ;Initialize receiver for other packets.
1542 F890              ExitNoInit                              ; 
1543 F890 20 D5 F7              jsr   Restore16                ;Restore 16 bytes of ZP from our stack.
1544 F893 20 F2 F7              jsr   UnGetBank                ;Restore memory state.
1545 F896 E2 30                 sep   #XBit+MBit               ;For returning to interrupt handler.
1546 F898 A9 03                 lda   #3                       ;Point to RR3 (interrupt status reg).
1547 F89A 8D 39 C0              sta   sccAReg
1548 F89D AD 39 C0              lda   sccAReg                  ;Get the latest value of RR3 to replace
1549 F8A0 0D 03 01              ora   SCCFlag2                 ;Fern's byte saved on the stack, and set
1550 F8A3 83 04                 sta   4,s                      ;our bit so he'll know we did something.
1551 F8A5 18                    clc                            ;Clear C to indicate we serviced the
1552 F8A6 6B                    rtl                            ;int.
1553 F8A7
1554 F8A7              dothedispatch                           ; 
1555 F8A7              * WARNING!!!
1556 F8A7              * we use the overflow flag to indicate whether or not
1557 F8A7              * we need to save the 16 bytes of zero page since the
1558 F8A7              * other zero page was saved on the aux side before we
1559 F8A7              * did a switch...therefore, MAKE SURE ANY CODE ADDED
1560 F8A7              * DOES NOT AFFECT THE OVERFLOW BIT BETWEEN WHERE WE
1561 F8A7              * SET IT AND WHERE WE PUSH A COPY OF IT ONTO THE STACK
1562 F8A7              *
1563 F8A7 EE 53 10              inc   busyFlag                 ;Make it busy for Dispatch.
1564 F8AA 20 7D F9              jsr   SaveState                ;Save interrupt vars. so interrupts can occur again
1565 F8AD BA                    tsx                            ;get current stack pointer
1566 F8AE 8E 69 11              stx   dstack                   ;save for later
1567 F8B1 E2 50                 sep   #xbit+vbit               ;8 bit x, set overflow bit to indicate normal stack
1568 F8B3 3B                    tsc                            ;get stack in a for tests
1569 F8B4 EB                    xba                            ;see what page of memory stack is in
1570 F8B5 49 01                 eor   #1                       ;is it page 1
1571 F8B7 D0 13                 bne   notinauxarea             ;no, so don't need to worry about stack being in aux
1572 F8B9 AE 16 C0              ldx   rdaltzp                  ;see if alt stack is in
1573 F8BC 10 0E                 bpl   notinauxarea             ;not in, so use stack as is
1574 F8BE EB                    xba                            ;get low word of stack pointer back
1575 F8BF 8F 01 01 01           sta   >altsp                   ;and save, so we can get it later
1576 F8C3 A9 01                 lda   #1
1577 F8C5 EB                    xba   
1578 F8C6 AF 00 01 01           lda   >mainsp                  ;get main stack pointer
1579 F8CA 1B                    tcs                            ;and use it
1580 F8CB B8                    clv                            ;we had the aux stack in, so must save main zp
1581 F8CC              notinauxarea                            ; 
1582 F8CC AD 68 C0              lda   statereg                 ;get state
1583 F8CF 8D 6B 11              sta   dstate                   ;save it
1584 F8D2 AE 18 C0              ldx   |rd80col                 ;see if 80store set
1585 F8D5 10 02                 bpl   irno80                   ;no
1586 F8D7 29 BF                 and   #$bf                     ;force page 1
1587 F8D9              irno80                                  ; 
1588 F8D9 29 40                 and   #$40                     ;put in standard state
1589 F8DB 09 08                 ora   #$08
1590 F8DD 8D 68 C0              sta   statereg                 ;now we are in a known state
1591 F8E0 AD 83 C0              lda   lcbank2
1592 F8E3 AD 83 C0              lda   lcbank2                  ;appletalk needs lcbank2 read/write enabled
1593 F8E6 C2 10                 rep   #xbit                    ;back to 16 bit x
1594 F8E8 08                    php                            ;save a copy of v bit (flag for which zp was in)
1595 F8E9 70 03                 bvs   @noextrasave             ;no need to save zero page, already done
1596 F8EB 20 C5 F7              jsr   Save16                   ;save the 16 bytes of zero page on the main side
1597 F8EE              @noextrasave  
1598 F8EE 08                    php   
1599 F8EF C2 30                 rep   #mbit+xbit
1600 F8F1 22 64 00 E1           jsl   incbusyflag              ;don't let scheduler come in here (critical code)
1601 F8F5 28                    plp   
1602 F8F6 58                    cli                            ;occur again, and turn on ints.
1603 F8F7 22 36 10 E1           jsl   PDispatch+$E10000        ;while (busy == 0) dispatch packets.
1604 F8FB 78                    sei                            ;Interrupts off.
1605 F8FC A9 E1                 lda   #$e1                     ;make sure bank e1 restored
1606 F8FE 48                    pha   
1607 F8FF AB                    plb   
1608 F900 CE 53 10              dec   busyFlag                 ;Remove the busy set for Dispatch.
1609 F903 C2 30                 rep   #mbit+xbit
1610 F905 AD 6B 11              lda   dstate
1611 F908 48                    pha                            ;need to use stack, since
1612 F909 AD 69 11              lda   dstack                   ;decbusyflag may re-enable ints
1613 F90C 48                    pha                            ;causing these vars to get changed
1614 F90D 22 68 00 E1           jsl   decbusyflag              ;let scheduler dispatch now (atalk active again)
1615 F911 FA                    plx                            ;recover the dstack variable
1616 F912 68                    pla                            ;get the state variable
1617 F913 28                    plp                            ;should be 8 bit a, 16 bit x
1618 F914 70 05                 bvs   @noextrarestore          ;no need to do the restore
1619 F916 48                    pha   
1620 F917 20 D5 F7              jsr   Restore16                ;restore the main zero page that was saved above
1621 F91A 68                    pla                            ;recover the state variable
1622 F91B              @noextrarestore  
1623 F91B 8D 68 C0              sta   statereg                 ;and restore it
1624 F91E 9A                    txs                            ;restore stack
1625 F91F 20 99 F9              jsr   RestorState              ;Get back interrupt vars.
1626 F922 60                    rts                            ;and return
1627 F923                       ENDP 
1628 F923
1629 F923              ****************************************************************
1630 F923              *
1631 F923              *  'QtrSecIRQ' handles quarter second interrupts.
1632 F923              *
1633 F923              *  Inputs:
1634 F923              *
1635 F923              *  Outputs:
1636 F923              *
1637 F923              ****************************************************************
1638 F923
1639 F923              QtrSecIRQ PROC 
1640 F923
1641 F923 08                    php   
1642 F924 8B                    phb   
1643 F925 E2 20                 sep   #MBit
1644 F927 C2 10                 rep   #XBit                    ;16 bit index.
1645 F929 A9 E1                 lda   #$E1                     ;Point to bank E1.
1646 F92B 48                    pha   
1647 F92C AB                    plb   
1648 F92D 8D 47 C0              sta   CLRVBLINT                ;Clear the 1/4 sec interrupt.
1649 F930 EE 55 10              inc   deltaT                   ;Time since the dispatcher got called.
1650 F933 AD 53 10              lda   busyFlag                 ;Can we call the dispatcher now?
1651 F936 D0 41                 bne   NoDispatch               ;No.
1652 F938 20 E5 F7              jsr   GetBank                  ;R/W LC bank 2, save StateReg on stack.
1653 F93B 20 7D F9              jsr   SaveState                ;Save state so ints can occur again.
1654 F93E 20 C5 F7              jsr   Save16                   ;Save some ZP.
1655 F941 AD 55 10              lda   deltaT                   ;Tell the dispatcher how long it's been.
1656 F944 9C 55 10              stz   deltaT                   ;Clear timer.
1657 F947 EE 53 10              inc   busyFlag                 ;We're busy.
1658 F94A C2 20                 rep   #MBit                    ;16 bit A for dispatch.
1659 F94C 22 64 00 E1           jsl   incbusyflag              ;tell scheduler we are critical
1660 F950 58                    cli                            ;Enable those ints!
1661 F951 20 95 FE              jsr   stacksave                ;save off stack if needed
1662 F954 20 1E EF              jsr   QtrSched                 ;Go to the scheduler.
1663 F957 E2 20                 sep   #MBit                    ;8 bit A for PDispatch.
1664 F959 22 36 10 E1           jsl   PDispatch+$E10000        ;Dispatch packets.
1665 F95D 20 0D FF              jsr   stackrestore             ;restore the stack space
1666 F960 CE 53 10              dec   busyFlag                 ;Not busy anymore.
1667 F963 08                    php   
1668 F964 C2 30                 rep   #mbit+xbit
1669 F966 22 68 00 E1           jsl   decbusyflag              ;let the scheduler call it's task
1670 F96A 22 4A 10 E1           jsl   OnExitVector             ;Call our new vector!
1671 F96E 28                    plp   
1672 F96F 78                    sei                            ;Disable ints.
1673 F970 20 D5 F7              jsr   Restore16                ;Get back ZP.
1674 F973 20 99 F9              jsr   RestorState              ;Get back info.
1675 F976 20 F2 F7              jsr   UnGetBank                ;Restore memory state.
1676 F979              NoDispatch                              ; 
1677 F979 AB                    plb   
1678 F97A 28                    plp   
1679 F97B 18                    clc   
1680 F97C 6B                    rtl   
1681 F97D                       ENDP 
1682 F97D
1683 F97D              ****************************************************************
1684 F97D              *
1685 F97D              *  'SaveState' puts interrupt vars on our private stack.
1686 F97D              *
1687 F97D              *  Inputs:
1688 F97D              *
1689 F97D              *  Outputs:
1690 F97D              *
1691 F97D              ****************************************************************
1692 F97D
1693 F97D              SaveState PROC 
1694 F97D
1695 F97D 08                    php   
1696 F97E C2 30                 rep   #MBit+XBit
1697 F980                       longa on
1698 F980 A2 C3 00              ldx   #irq_intflag
1699 F983 A9 09 00              lda   #9                       ;Save 9 bytes.
1700 F986 20 47 E5              jsr   SaveE1                   ;Save other interrupt vars on stack.
1701 F989 A2 08 01              ldx   #irq_A
1702 F98C A9 13 00              lda   #19                      ;Save 19 bytes.
1703 F98F 20 47 E5              jsr   SaveE1                   ;Save interrupt vars on private stack.
1704 F992 E2 20                 sep   #MBit                    ;8 bit A.
1705 F994 9C CB 00              stz   |irq_active              ;Pretend ints are not active.
1706 F997 28                    plp   
1707 F998                       longa off
1708 F998 60                    rts   
1709 F999                       ENDP 
1710 F999
1711 F999              ****************************************************************
1712 F999              *
1713 F999              *  'RestorState' gets interrupt vars off of our private stack.
1714 F999              *
1715 F999              *  Inputs:
1716 F999              *
1717 F999              *  Outputs:
1718 F999              *
1719 F999              ****************************************************************
1720 F999
1721 F999              RestorState PROC 
1722 F999
1723 F999 08                    php   
1724 F99A C2 30                 rep   #MBit+XBit
1725 F99C                       longa on
1726 F99C A0 08 01              ldy   #irq_A
1727 F99F A9 13 00              lda   #19                      ;Restore 19 bytes.
1728 F9A2 20 6E E5              jsr   RestoreE1                ;Restore interrupt vars fromon stack.
1729 F9A5 A0 C3 00              ldy   #irq_intflag
1730 F9A8 A9 09 00              lda   #9                       ;Restore 9 bytes.
1731 F9AB 20 6E E5              jsr   RestoreE1                ;Restore other vars from stack.
1732 F9AE 28                    plp   
1733 F9AF                       longa off
1734 F9AF 60                    rts   
1735 F9B0                       ENDP 
1736 F9B0
1737 F9B0              LongForbid PROC EXPORT 
1738 F9B0 20 B8 F9              jsr   Forbid
1739 F9B3 6B                    rtl   
1740 F9B4                       ENDP 
1741 F9B4
1742 F9B4              LongPermit PROC EXPORT 
1743 F9B4 20 E0 F9              jsr   Permit
1744 F9B7 6B                    rtl   
1745 F9B8                       ENDP 
1746 F9B8
1747 F9B8              ****************************************************************
1748 F9B8              *
1749 F9B8              *  'EnterCrit'
1750 F9B8              *
1751 F9B8              *  Inputs:
1752 F9B8              *
1753 F9B8              *  Outputs:
1754 F9B8              *
1755 F9B8              ****************************************************************
1756 F9B8
1757 F9B8              EnterCrit PROC 
1758 F9B8
1759 F9B8                       EXPORT lforbid 
1760 F9B8              lforbid                                 ;
1761 F9B8                       EXPORT Forbid 
1762 F9B8              Forbid                                  ; 
1763 F9B8
1764 F9B8 48                    pha   
1765 F9B9 08                    php   
1766 F9BA 8B                    phb   
1767 F9BB E2 20                 sep   #mbit
1768 F9BD                       longa off
1769 F9BD AF 68 C0 00           lda   >statereg                ;get state of machine
1770 F9C1 48                    pha   
1771 F9C2 29 CF                 and   #$cf                     ;bits 4&5 zero force read and write main bank
1772 F9C4 8F 68 C0 00           sta   >statereg
1773 F9C8 C2 30                 rep   #mbit+xbit
1774 F9CA 22 64 00 E1           jsl   incbusyflag              ;tell scheduler we are busy
1775 F9CE E2 20                 sep   #MBit                    ;8 bit A.
1776 F9D0 A9 E1                 lda   #$E1
1777 F9D2 48                    pha   
1778 F9D3 AB                    plb   
1779 F9D4 EE 53 10              inc   busyFlag
1780 F9D7 68                    pla                            ;recover state of machine
1781 F9D8 8F 68 C0 00           sta   >statereg                ;and restore it
1782 F9DC AB                    plb   
1783 F9DD 28                    plp                            ;Restore state.
1784 F9DE 68                    pla   
1785 F9DF 60                    rts   
1786 F9E0                       ENDP 
1787 F9E0
1788 F9E0              ****************************************************************
1789 F9E0              *
1790 F9E0              *  'ExitCrit'
1791 F9E0              *
1792 F9E0              *  Inputs:
1793 F9E0              *
1794 F9E0              *  Outputs:
1795 F9E0              *
1796 F9E0              ****************************************************************
1797 F9E0
1798 F9E0              ExitCrit PROC 
1799 F9E0
1800 F9E0                       longa off
1801 F9E0                       EXPORT Permit 
1802 F9E0              Permit                                  ;
1803 F9E0                       EXPORT lpermit 
1804 F9E0              lpermit                                 ;
1805 F9E0
1806 F9E0 48                    pha   
1807 F9E1 DA                    phx   
1808 F9E2 5A                    phy   
1809 F9E3 0B                    phd                            ;save off direct page
1810 F9E4 F4 00 00              pea   $0000                    ;prepare to set direct page to zero
1811 F9E7 2B                    pld                            ;get direct page of zero
1812 F9E8 08                    php   
1813 F9E9 E2 20                 sep   #MBit                    ;8 bit A.
1814 F9EB                       longa off
1815 F9EB AF 68 C0 00           lda   >statereg                ;get state of machine
1816 F9EF 48                    pha   
1817 F9F0 29 CF                 and   #$cf                     ;bits 4&5 zero force read and write main bank
1818 F9F2 8F 68 C0 00           sta   >statereg
1819 F9F6 C2 10                 rep   #XBit                    ;16 bit X.
1820 F9F8 8B                    phb   
1821 F9F9 A9 E1                 lda   #$E1                     ;Change to bank E1.
1822 F9FB 48                    pha   
1823 F9FC AB                    plb   
1824 F9FD 20 E5 F7              jsr   GetBank                  ;Get LC bank 2.
1825 FA00 08                    php                            ;Save mode for later.
1826 FA01 78                    sei                            ;No ints while changing busyFlag.
1827 FA02 CE 53 10              dec   busyFlag
1828 FA05 D0 33                 bne   Done                     ;If zero, we can try to dispatch
1829 FA07 AE A9 10              ldx   curRBuf                  ;packets.  Are packets available?
1830 FA0A BD 01 00              lda   |buf_next+1,x            ;Look at high byte of next field:
1831 FA0D F0 15                 beq   NoPkts                   ;If zero, no packets.
1832 FA0F EE 53 10              inc   busyFlag                 ;packets.  Increment busy for Dispatch.
1833 FA12 28                    plp                            ;Get back state of interrupt
1834 FA13 08                    php                            ;enable flag and save again.
1835 FA14 20 C5 F7              jsr   Save16                   ;Save 16 bytes of ZP.
1836 FA17 22 36 10 E1           jsl   PDispatch+$E10000        ;try to dispatch a packet.
1837 FA1B 20 D5 F7              jsr   Restore16                ;Get back ZP.
1838 FA1E 78                    sei                            ;No ints while looking at busy flag.
1839 FA1F CE 53 10              dec   busyFlag                 ;Undo the busy. If still zero,
1840 FA22 D0 16                 bne   Done                     ;check for a pending 1/4 sec interrupt.
1841 FA24              NoPkts                                  ; 
1842 FA24 AD 55 10              lda   deltaT                   ;If time > 0, one is waiting.
1843 FA27 F0 11                 beq   Done                     ;Zero, none waiting.
1844 FA29 9C 55 10              stz   deltaT                   ;Clear timer.
1845 FA2C EE 53 10              inc   busyFlag                 ;Now we're busy.
1846 FA2F 28                    plp                            ;Get back int enable state.
1847 FA30 08                    php   
1848 FA31 C2 30                 rep   #MBit+XBit
1849 FA33 20 1E EF              jsr   QtrSched                 ;Dispatch 1/4 sec interrupts.
1850 FA36 78                    sei   
1851 FA37 CE 53 10              dec   busyFlag                 ;Undo the busy.
1852 FA3A              Done                                    ; 
1853 FA3A 28                    plp   
1854 FA3B 20 F2 F7              jsr   UnGetBank                ;Restore memory state.
1855 FA3E C2 30                 rep   #mbit+xbit
1856 FA40 22 68 00 E1           jsl   decbusyflag              ;let scheduler run now if down to zero
1857 FA44 AB                    plb   
1858 FA45 E2 20                 sep   #mbit                    ;state is 1 byte
1859 FA47 68                    pla                            ;recover state of machine
1860 FA48 8F 68 C0 00           sta   >statereg                ;and restore it
1861 FA4C 28                    plp   
1862 FA4D 2B                    pld                            ;recover original direct page
1863 FA4E 7A                    ply   
1864 FA4F FA                    plx   
1865 FA50 68                    pla   
1866 FA51 60                    rts   
1867 FA52                       ENDP 
1868 FA52
1869 FA52              ***************************************************************
1870 FA52              *
1871 FA52              *  'RecvPacket' should be called to receive a packet from a non-interrupt
1872 FA52              *  environment.  The routine will wait a maximum of IFGTime (200 usec.)
1873 FA52              *  for a packet before returning with a time out error.  Only 3 packet classes
1874 FA52              *  are accepted: LAPAck, LAPCTS, and non LAP-control packets (i.e., data
1875 FA52              *  packets).  Any directed packet (non broadcast), however, will set the flag
1876 FA52              *  'addrUsed'.  LAPCTS packets will set the flag 'gotCTS', and data packets
1877 FA52              *  will set the flag 'gotData'.  Data packets will only be accepted if the flag
1878 FA52              *  'needData' is set.
1879 FA52              *
1880 FA52              *  Inputs:
1881 FA52              *
1882 FA52              *  Outputs:
1883 FA52              *
1884 FA52              ****************************************************************
1885 FA52
1886 FA52              RecvPacket PROC 
1887 FA52
1888 FA52 9C 54 10              stz   pktError                 ;No receive errors (yet).
1889 FA55 A0 00 00              ldy   #0                       ;Point to scc1 (, 2, 3).
1890 FA58 A2 64 00              ldx   #TIFGap                  ;Wait max of IFG (200 us) for packet.
1891 FA5B 18                    clc                            ;Set up loop info on stack for later.
1892 FA5C 08                    php                            ;Push a flag with C=0 to stop the loop.
1893 FA5D 38                    sec   
1894 FA5E 08                    php                            ;Push 3 flags with C=1 to get 4 bytes.
1895 FA5F 08                    php   
1896 FA60 08                    php   
1897 FA61              WaitIFG                                 ; 
1898 FA61 B2 88                 lda   (sccReg)                 ;Check for data ready.
1899 FA63 29 01                 and   #RxAvail
1900 FA65 D0 06                 bne   DataAvail
1901 FA67 CA                    dex                            ;Check for time out.
1902 FA68 D0 F7                 bne   WaitIFG
1903 FA6A 4C D3 FA              jmp   ErrExit                  ;Time out, so exit.
1904 FA6D              DataAvail                               ; 
1905 FA6D B2 8A                 lda   (sccDat)                 ;Get data.
1906 FA6F 99 A6 10              sta   scc1A,y                  ;Store it.
1907 FA72 C8                    iny                            ;Point to the next byte.
1908 FA73 A2 07 00              ldx   #TByte                   ;Reset time out timer for single byte.
1909 FA76 C0 03 00              cpy   #3                       ;See if we've gotten all 3 bytes yet.
1910 FA79 D0 E6                 bne   WaitIFG                  ;Keep looping.
1911 FA7B AD A8 10              lda   scc3                     ;Look at LAP type.
1912 FA7E 30 37                 bmi   LAPPkt                   ;Go handle LAP packet.
1913 FA80 AD 51 10              lda   needData                 ;Do we need a data packet?
1914 FA83 F0 51                 beq   Exit                     ;No: exit.
1915 FA85 AC AF 10              ldy   curOffset
1916 FA88 AD A8 10              lda   scc3                     ;See if this packet needs to be check-
1917 FA8B C9 02                 cmp   #DDPLong                 ;summed.
1918 FA8D D0 0C                 bne   AfterHeader              ;If not, just get data.
1919 FA8F 38                    sec                            ;Single byte mode.
1920 FA90              RLoop                                   ; 
1921 FA90 20 F2 FA              jsr   RecvBytes                ;Get a byte of DDP header.
1922 FA93 97 8C                 sta   [ptr0],y                 ;Store it.
1923 FA95 C8                    iny   
1924 FA96 28                    plp                            ;Get loop control off stack.
1925 FA97 B0 F7                 bcs   RLoop                    ;If C set, loop.
1926 FA99 DA                    phx                            ;Push 4 dummy bytes on stack.
1927 FA9A DA                    phx   
1928 FA9B              AfterHeader                             ; 
1929 FA9B 64 80                 stz   cmndList                 ;Zero the checksum.
1930 FA9D 64 81                 stz   cmndList+1
1931 FA9F 18                    clc                            ;Indicate multi byte mode.
1932 FAA0 20 F2 FA              jsr   RecvBytes                ;Receive the whole packet.
1933 FAA3 AD 54 10              lda   pktError                 ;See if any errors occured.
1934 FAA6 30 2E                 bmi   Exit                     ;Yes. Exit.
1935 FAA8 AD 52 10              lda   addrValid                ;Is our address valid?
1936 FAAB F0 29                 beq   Exit                     ;No: exit.
1937 FAAD EE 93 10              inc   gotData                  ;Indicate that we got a data packet.
1938 FAB0 A6 80                 ldx   cmndList                 ;Put the checksum in page E1.
1939 FAB2 8E A2 10              stx   ckSum
1940 FAB5 80 1F                 bra   Exit                     ;Return.
1941 FAB7
1942 FAB7              LAPPkt                                  ; 
1943 FAB7 38                    sec                            ;Single byte mode.
1944 FAB8 20 F2 FA              jsr   RecvBytes                ;Get first CRC byte.
1945 FABB 90 16                 bcc   ErrExit                  ;Last byte: error, so exit.
1946 FABD 20 F2 FA              jsr   RecvBytes                ;Get second CRC byte.
1947 FAC0 B0 11                 bcs   ErrExit                  ;Not last byte: error, so exit.
1948 FAC2 AD 54 10              lda   pktError                 ;See if any errors.
1949 FAC5 30 0F                 bmi   Exit                     ;Yep. Exit.
1950 FAC7 AD A8 10              lda   scc3                     ;Look at LAP type.
1951 FACA C9 85                 cmp   #LAPCTS                  ;Is it a CTS?
1952 FACC D0 08                 bne   Exit                     ;No, so don't do anything.
1953 FACE 8D 92 10              sta   gotCTS                   ;Yes, register it.
1954 FAD1 80 03                 bra   Exit
1955 FAD3              ErrExit                                 ; 
1956 FAD3 CE 54 10              dec   pktError                 ;If get here, pktError was 0. Now $ff.
1957 FAD6              Exit                                    ; 
1958 FAD6 FA                    plx                            ;Remove loop control bytes from stack.
1959 FAD7 FA                    plx   
1960 FAD8 AD 54 10              lda   pktError                 ;Was there an error?
1961 FADB 30 0B                 bmi   BCST                     ;Yes, ignore the packet.
1962 FADD AD A6 10              lda   scc1A
1963 FAE0 CD 95 10              cmp   source                   ;Is it to our address?
1964 FAE3 D0 03                 bne   BCST                     ;No, must be broadcast.
1965 FAE5 8D 91 10              sta   addrUsed                 ;someone is using this address.
1966 FAE8              BCST                                    ; 
1967 FAE8 4C BA FD              jmp   RecvInit                 ;Init receiver for other packets
1968 FAEB                       ENDP 
1969 FAEB
1970 FAEB              ****************************************************************
1971 FAEB              *
1972 FAEB              *  'RecvBytes' reads bytes into the current receive buffer.  It has two
1973 FAEB              *  modes of operation, depending on the setting of the C bit when called.
1974 FAEB              *  If C is cleared when called, bytes will be continuously read until the
1975 FAEB              *  end of the packet or an error occurs, and each byte will be added to the
1976 FAEB              *  'ckSum'.  If C is set, however, only one byte will be read and returned
1977 FAEB              *  in A without being buffered or added to the checksum.  Control will
1978 FAEB              *  be passed immediately back to the caller.
1979 FAEB              *
1980 FAEB              *  Inputs:
1981 FAEB              *
1982 FAEB              *  Outputs:
1983 FAEB              *
1984 FAEB              ****************************************************************
1985 FAEB
1986 FAEB              Set      PROC 
1987 FAEB
1988 FAEB 38                    sec                            ;Shift in 1.
1989 FAEC 2A                    rol   A                        ;Left.
1990 FAED 85 80                 sta   cmndList
1991 FAEF E2 20                 sep   #MBit                    ;Back to 8 bits.
1992 FAF1 18                    clc                            ;Ensure multi-byte mode.
1993 FAF2
1994 FAF2                       entry RecvBytes                ; EXPORT -> ENTRY  **TGH
1995 FAF2              RecvBytes                               ;       
1996 FAF2
1997 FAF2 B2 88                 lda   (sccReg)                 ;Look at the byte available bit.
1998 FAF4 29 01                 and   #RxAvail
1999 FAF6 D0 10                 bne   Loop2                    ;Got a byte: continue.
2000 FAF8 A2 07 00              ldx   #TByte                   ;Byte time out.
2001 FAFB              Loop1                                   ; 
2002 FAFB B2 88                 lda   (sccReg)                 ;Look at the byte avail bit.
2003 FAFD 29 01                 and   #RxAvail
2004 FAFF D0 07                 bne   Loop2
2005 FB01 CA                    dex                            ;Check for time out.
2006 FB02 D0 F7                 bne   loop1
2007 FB04 A9 08                 lda   #TOutErr                 ;Time out error.
2008 FB06 80 2A                 bra   DoError
2009 FB08              Loop2                                   ; 
2010 FB08 92 88                 sta   (sccReg)                 ;If we get here, A = 1 (point to
2011 FB0A B2 88                 lda   (sccReg)                 ;read register 1). Get error status.
2012 FB0C 29 A0                 and   #$A0                     ;Check for end of frame or overrun.
2013 FB0E D0 20                 bne   Special                  ;Handle special case.
2014 FB10 B2 8A                 lda   (sccDat)                 ;Get the data byte.
2015 FB12 90 02                 bcc   MultiMode                ;If C = 0, get multiple bytes.
2016 FB14 38                    sec                            ;Indicate not end of packet.
2017 FB15 60                    rts                            ;Return with the byte in A.
2018 FB16              MultiMode                               ; 
2019 FB16 97 8C                 sta   [ptr0],y                 ;Store the byte.
2020 FB18 C8                    iny                            ;Move to next byte.
2021 FB19 F0 11                 beq   TooBigErr                ;If zero, buffer is full.
2022 FB1B C2 20                 rep   #MBit                    ;16 bit A.
2023 FB1D                       longa on
2024 FB1D 29 FF 00              and   #$ff                     ;Mask off high byte.
2025 FB20 65 80                 adc   cmndList                 ;Add new byte to the checksum.
2026 FB22 30 C7                 bmi   Set                      ;Bit 15 = 1: go shift in 1.
2027 FB24 18                    clc                            ;Bit 15 = 0: shift in 0.
2028 FB25 2A                    rol   A                        ;Shift it left, now C = 0.
2029 FB26 85 80                 sta   cmndList                 ;Store it.
2030 FB28 E2 20                 sep   #MBit                    ;Back to 8 bits.
2031 FB2A                       longa off
2032 FB2A 80 C6                 bra   RecvBytes                ;Loop. C = 0 still for multi-byte mode.
2033 FB2C
2034 FB2C              TooBigErr                               ; 
2035 FB2C A9 10                 lda   #tBigErr                 ;Set the appropriate error bit.
2036 FB2E 80 02                 bra   DoError
2037 FB30
2038 FB30              Special                                 ; 
2039 FB30 30 10                 bmi   LastByte                 ;If -, last byte in packet.  Else
2040 FB32              ;                                        overrun bit is set in A. Record it.
2041 FB32              DoError                                 ; ;Decide whether or not to record the
2042 FB32 09 80                 ora   #$80                     ;error.  Set the error bit.
2043 FB34 AA                    tax                            ;Get pktError and look at the lock bit
2044 FB35 AD 54 10              lda   pktError                 ;to see whether we should report this
2045 FB38 29 01                 and   #1                       ;new error.  If set, don't record.
2046 FB3A 18                    clc                            ;Indicate end of packet (whether or not
2047 FB3B D0 04                 bne   NoRecord                 ;it's the end).
2048 FB3D 8A                    txa                            ;Get back the new error.
2049 FB3E 0C 54 10              tsb   pktError                 ;Record it.
2050 FB41              NoRecord                                ; 
2051 FB41 60                    rts   
2052 FB42
2053 FB42              LastByte                                ; 
2054 FB42 A9 01                 lda   #1                       ;Get status register again.
2055 FB44 92 88                 sta   (sccReg)
2056 FB46 B2 88                 lda   (sccReg)
2057 FB48 29 60                 and   #$60                     ;Mask all but CRC and overrun errors.
2058 FB4A D0 E6                 bne   DoError                  ;Use bits in A as error bits.
2059 FB4C A9 01                 lda   #1                       ;If not an error, a packet has been
2060 FB4E 8D 54 10              sta   pktError                 ;successfully received, so set the lock
2061 FB51 18                    clc                            ;bit and clear C to indicate the end of
2062 FB52 60                    rts                            ;the packet.
2063 FB53                       ENDP 
2064 FB53              **************************************************************
2065 FB53              *
2066 FB53              *  'XmitPacket' performs CSMA.CA transmission of the packet in the buffer
2067 FB53              *  data structure pointed to by 'xmitBDS'.
2068 FB53              *
2069 FB53              *  Inputs:  'dest', 'lapType', and 'xmitBDS'
2070 FB53              *
2071 FB53              *  Outputs:
2072 FB53              *
2073 FB53              ****************************************************************
2074 FB53
2075 FB53              XmitPacket PROC 
2076 FB53
2077 FB53 08                    php                            ;Save mode.
2078 FB54 E2 20                 sep   #MBit                    ;8 bits.
2079 FB56 AD 96 10              lda   lapType                  ;Is it an Enq?
2080 FB59 C9 81                 cmp   #LAPEnq
2081 FB5B F0 2E                 beq   NoCount                  ;If so, don't count size of BDS.
2082 FB5D C2 20                 rep   #MBit
2083 FB5F                       longa on
2084 FB5F              CountBDS                                ; ;First count bytes, see if it's too long
2085 FB5F AE 9C 10              ldx   txBDS                    ;Make temporary copy of the pointer to
2086 FB62 86 8C                 stx   ptr0                     ;the BDS.
2087 FB64 AE 9E 10              ldx   txBDS+2
2088 FB67 86 8E                 stx   ptr0+2
2089 FB69 A9 58 02              lda   #MaxData                 ;Set up to max size of LAP data.
2090 FB6C A0 00 00              ldy   #0                       ;Point to first BDS entry.
2091 FB6F              CountLoop                               ; 
2092 FB6F 48                    pha                            ;Save amount left before too big.
2093 FB70 B7 8C                 lda   [ptr0],y                 ;Get this count.
2094 FB72 1A                    inc   A                        ;See if it's $FFFF.
2095 FB73 F0 13                 beq   Done                     ;If so, done.
2096 FB75 68                    pla                            ;Get back amount remaining.
2097 FB76 38                    sec   
2098 FB77 F7 8C                 sbc   [ptr0],y                 ;Subtract the size of this entry.
2099 FB79 10 05                 bpl   OKLength                 ;If we go -, it's too long.
2100 FB7B
2101 FB7B A9 03 00              lda   #SizeErr                 ;Report error.
2102 FB7E 28                    plp                            ;Get back mode
2103 FB7F 60                    rts                            ;return.
2104 FB80              OKLength                                ; 
2105 FB80 C8                    iny                            ;Move ahead 6 to the next BDS entry.
2106 FB81 C8                    iny   
2107 FB82 C8                    iny   
2108 FB83 C8                    iny   
2109 FB84 C8                    iny   
2110 FB85 C8                    iny   
2111 FB86 80 E7                 bra   CountLoop                ;Loop.
2112 FB88              Done                                    ; 
2113 FB88 68                    pla                            ;Get stuff off stack.
2114 FB89 E2 20                 sep   #MBit
2115 FB8B                       longa off
2116 FB8B              NoCount                                 ; 
2117 FB8B AE A0 10              ldx   whichSCC                 ;Set up pointers to SCC.
2118 FB8E 86 88                 stx   sccReg
2119 FB90 E8                    inx   
2120 FB91 E8                    inx   
2121 FB92 86 8A                 stx   sccDat
2122 FB94 A9 01                 lda   #1                       ;Set this bit to use the Mega II mouse
2123 FB96 0C 41 C0              tsb   mouseMode                ;counter for line activity detection.
2124 FB99 AD 4E 10              lda   colHist                  ;Look at recent collision history.
2125 FB9C 20 E2 FC              jsr   BitCount                 ;Count # of cols. in the last 8.
2126 FB9F 90 0A                 bcc   AdjBk2                   ;<2 then check defers.
2127 FBA1 F0 08                 beq   AdjBk2                   ;=2 then check defers.
2128 FBA3 2E 50 10              rol   gBackOff                 ;gBackOff = gBackOff * 2 + 1 (mask bit).
2129 FBA6 9C 4E 10              stz   colHist                  ;Clear collision history.
2130 FBA9 80 10                 bra   AdjBk3
2131 FBAB              AdjBk2                                  ; 
2132 FBAB AD 4F 10              lda   defHist                  ;Look at defer history.
2133 FBAE 20 E2 FC              jsr   BitCount                 ;Count defers in past 8.
2134 FBB1 B0 08                 bcs   AdjBk3                   ;If >= 2, continue.
2135 FBB3 4E 50 10              lsr   gBackOff                 ;gBackOff = gBackOff / 2.
2136 FBB6 A9 FF                 lda   #$ff                     ;Set all def history bits.
2137 FBB8 8D 4F 10              sta   defHist
2138 FBBB              AdjBk3                                  ; 
2139 FBBB AD 50 10              lda   gBackOff                 ;Copy gBackOff to
2140 FBBE 8D 97 10              sta   lBackOff                 ;our local copy.
2141 FBC1 0E 4F 10              asl   defHist                  ;Throw away the oldest history bit.
2142 FBC4 0E 4E 10              asl   colHist                  ;Throw away the oldest history bit.
2143 FBC7 A2 20 20              ldx   #$2020                   ;Max defers, Max collisions.
2144 FBCA 8E 98 10              stx   colTries                 ;Set them up.
2145 FBCD
2146 FBCD              CDSPktWait                              ; 
2147 FBCD 28                    plp                            ;Get back original setting of interrupt
2148 FBCE 08                    php                            ;enable bit.
2149 FBCF 20 B3 F5              jsr   Random                   ;Generate random number now for backoff.
2150 FBD2 A0 A0 0F              ldy   #TWLFree                 ;30 msec. time out for free line.
2151 FBD5 AE 8D 10              ldx   whichMouse               ;Pick which mouse counter to watch.
2152 FBD8              WLFLoop                                 ; 
2153 FBD8 BD 00 00              lda   |0,X                     ;Clear the mouse counter.
2154 FBDB 20 66 FC              jsr   RTSAddr                  ;Wait about a bit time.
2155 FBDE BD 00 00              lda   |0,X                     ;Get current count: is anyone on the
2156 FBE1 F0 08                 beq   CDSBkOff                 ;line?  If not, we got it.
2157 FBE3 88                    dey                            ;Check for time out.
2158 FBE4 D0 F2                 bne   WLFLoop                  ;No time out, continue.
2159 FBE6 20 BA FD              jsr   RecvInit                 ;Otherwise, time out: receiver stuck,
2160 FBE9 80 E2                 bra   CDSPktWait               ;so reset it.
2161 FBEB
2162 FBEB              CDSBkOff                                ; 
2163 FBEB A0 04 00              ldy   #4                       ;Wait 400 usec. inter dialog gap,
2164 FBEE 20 F3 FC              jsr   WLineBusy                ;checking for line busy.
2165 FBF1 B0 DA                 bcs   CDSPktWait               ;Line busy: keep waiting.
2166 FBF3 AD 90 10              lda   seed+1                   ;Get a random number.
2167 FBF6 2D 97 10              and   lBackOff                 ;And (effectively multiply) by lBackOff.
2168 FBF9 C2 20                 rep   #MBit                    ;16 bit A.
2169 FBFB                       longa on
2170 FBFB 29 0F 00              and   #$f                      ;Enforce max wait of 15.
2171 FBFE A8                    tay                            ;Set for WLineBusy, 100 usec intervals.
2172 FBFF E2 20                 sep   #MBit                    ;Back to 8.
2173 FC01                       longa off
2174 FC01 F0 05                 beq   GotLine                  ;If random backoff time is 0, continue.
2175 FC03 20 F3 FC              jsr   WLineBusy                ;checking for line busy.
2176 FC06 B0 42                 bcs   Defer                    ;Someone on line: defer.
2177 FC08
2178 FC08              GotLine                                 ; 
2179 FC08 78                    sei                            ;No ints from now on.
2180 FC09 9C 92 10              stz   gotCTS                   ;Clear CTS received flag.
2181 FC0C AE 94 10              ldx   dest                     ;Get dest address.
2182 FC0F A9 81                 lda   #LAPEnq                  ;See if sending a LAPEnq.
2183 FC11 CD 96 10              cmp   lapType
2184 FC14 F0 02                 beq   DoEnq                    ;If so, A already has #LAPEnq.
2185 FC16 A9 84                 lda   #LAPRTS                  ;If not, do an RTS instead.
2186 FC18              DoEnq                                   ; 
2187 FC18 20 67 FC              jsr   XmitLAP                  ;Send a LAP packet.
2188 FC1B AD 94 10              lda   dest                     ;Check for broadcast.
2189 FC1E 1A                    inc   A
2190 FC1F F0 37                 beq   JustWait                 ;If broadcast, don't expect a CTS.
2191 FC21 20 52 FA              jsr   RecvPacket               ;Try to receive CTS.
2192 FC24 AD 96 10              lda   lapType                  ;Was it an enquiry?
2193 FC27 C9 81                 cmp   #LAPEnq
2194 FC29 D0 07                 bne   ChkCTS                   ;If not, see if we got a CTS.
2195 FC2B AD 91 10              lda   addrUsed                 ;If so, see if anyone used our address.
2196 FC2E F0 07                 beq   Collision                ;No: pretend a collision, keep trying
2197 FC30 28                    plp                            ;enquiries. Yes: return.
2198 FC31 60                    rts   
2199 FC32              ChkCTS                                  ; 
2200 FC32 AD 92 10              lda   gotCTS                   ;See if we got it.
2201 FC35 D0 29                 bne   TransPkt                 ;If so, transmit the packet.
2202 FC37
2203 FC37              Collision                               ; ;Otherwise, probably a collision.
2204 FC37 A9 01                 lda   #1                       ;Set the current collision history bit.
2205 FC39 0C 4E 10              tsb   colHist
2206 FC3C 38                    sec                            ;Multiply lBackOff by 2.
2207 FC3D 2E 97 10              rol   lBackOff
2208 FC40 A9 04                 lda   #RetryErr
2209 FC42 CE 98 10              dec   colTries                 ;See if too many collisions.
2210 FC45 F0 1E                 beq   Exit                     ;If so, exit with excess collision err.
2211 FC47              CDSBranch                               ; 
2212 FC47 82 83 FF              brl   CDSPktWait
2213 FC4A
2214 FC4A              Defer                                   ; 
2215 FC4A A9 01                 lda   #1                       ;Set current defer history bit.
2216 FC4C 0C 4F 10              tsb   defHist
2217 FC4F CE 99 10              dec   defTries                 ;See if too many defers.
2218 FC52 D0 F3                 bne   CDSBranch                ;If not, try again.
2219 FC54 A9 04                 lda   #RetryErr                ;Report excess defers error.
2220 FC56 80 0D                 bra   Exit
2221 FC58
2222 FC58              JustWait                                ; 
2223 FC58 A0 01 00              ldy   #1                       ;Wait 100 usec, checking for line busy.
2224 FC5B              *                                       ;(Hardware SCC delay makes this 200 us.)
2225 FC5B 20 F3 FC              jsr   WLineBusy
2226 FC5E B0 D7                 bcs   Collision                ;If someone on line, record collision.
2227 FC60
2228 FC60              TransPkt                                ; ;Otherwise, transmit the packet.
2229 FC60 20 11 FD              jsr   XmitBDS
2230 FC63 A9 00                 lda   #0                       ;Report successful transmission.
2231 FC65
2232 FC65              Exit                                    ; 
2233 FC65 28                    plp                            ;Restore mode.
2234 FC66
2235 FC66                       entry RTSAddr                  ; EXPORT -> ENTRY  **TGH
2236 FC66              RTSAddr                                 ;     
2237 FC66
2238 FC66 60                    rts                            ;Return.
2239 FC67                       ENDP 
2240 FC67
2241 FC67              ***************************************************************
2242 FC67              *
2243 FC67              *  'XmitLAP'  sends a 3 byte lap packet.  A contains the LAP type, X
2244 FC67              *  contains the destination address.
2245 FC67              *
2246 FC67              *  Inputs:
2247 FC67              *
2248 FC67              *  Outputs:
2249 FC67              *
2250 FC67              ****************************************************************
2251 FC67
2252 FC67              XmitLAP  PROC 
2253 FC67
2254 FC67 48                    pha                            ;Save the LAP type on the stack.
2255 FC68 20 A7 FC              jsr   XmitBegin                ;Start the transmission.
2256 FC6B AD 95 10              lda   source                   ;Get our node number.
2257 FC6E AA                    tax   
2258 FC6F 20 D8 FC              jsr   XmitOne                  ;Send it.
2259 FC72 68                    pla                            ;Get LAP type back.
2260 FC73 AA                    tax   
2261 FC74 4C 8F FD              jmp   XmitEnd                  ;Send it and exit through XmitEnd.
2262 FC77                       ENDP 
2263 FC77
2264 FC77              ***************************************************************
2265 FC77              *
2266 FC77              *  'fXmitLAP'  sends a 3 byte lap packet.  A contains the LAP type, X
2267 FC77              *  contains the destination address. (NOTE: this does not send the
2268 FC77              *  sync pulse at the beginning, and should only be called when we
2269 FC77              *  are sending back immediately to someone who sent us an RTS or ENQ
2270 FC77              *
2271 FC77              *  Inputs:
2272 FC77              *
2273 FC77              *  Outputs:
2274 FC77              *
2275 FC77              ****************************************************************
2276 FC77
2277 FC77              fXmitLAP PROC 
2278 FC77
2279 FC77 48                    pha                            ;Save the LAP type on the stack.
2280 FC78 A9 03                 lda   #3                       ;Start by disabling the receiver.
2281 FC7A 92 88                 sta   (sccReg)                 ;Point to reg 3.
2282 FC7C A9 D0                 lda   #DisRx
2283 FC7E 92 88                 sta   (sccReg)
2284 FC80 A9 05                 lda   #5                       ;Now enable drivers
2285 FC82 A8                    tay                            ;Y = 5.
2286 FC83 92 88                 sta   (sccReg)                 ;pulse.
2287 FC85 A9 E3                 lda   #EnbRTS
2288 FC87 92 88                 sta   (sccReg)
2289 FC89 98                    tya                            ;Now enable drivers and transmitter.
2290 FC8A 92 88                 sta   (sccReg)
2291 FC8C A9 EB                 lda   #EnbTxRTS
2292 FC8E 92 88                 sta   (sccReg)
2293 FC90 A9 80                 lda   #ResTxCRC                ;Initialize the transmitter's CRC
2294 FC92 92 88                 sta   (sccReg)                 ;generator.
2295 FC94 8A                    txa                            ;Get the first character of the packet.
2296 FC95 92 8A                 sta   (sccDat)                 ;Send it.
2297 FC97 A9 C0                 lda   #ResetUnd                ;Reset transmit underrun error.
2298 FC99 92 88                 sta   (sccReg)
2299 FC9B AD 95 10              lda   source                   ;Get our node number.
2300 FC9E AA                    tax   
2301 FC9F 20 D8 FC              jsr   XmitOne                  ;Send it.
2302 FCA2 68                    pla                            ;Get LAP type back.
2303 FCA3 AA                    tax   
2304 FCA4 4C 8F FD              jmp   XmitEnd                  ;Send it and exit through XmitEnd.
2305 FCA7                       ENDP 
2306 FCA7
2307 FCA7              ****************************************************************
2308 FCA7              *
2309 FCA7              *  'XmitBegin' begins a packet transmission by sending the synchronization
2310 FCA7              *  pulse, two flags, and the data byte passed in X.
2311 FCA7              *
2312 FCA7              *  Inputs:
2313 FCA7              *
2314 FCA7              *  Outputs:
2315 FCA7              *
2316 FCA7              ****************************************************************
2317 FCA7
2318 FCA7              XmitBegin PROC 
2319 FCA7
2320 FCA7 A9 03                 lda   #3                       ;Start by disabling the receiver.
2321 FCA9 92 88                 sta   (sccReg)                 ;Point to reg 3.
2322 FCAB A9 D0                 lda   #DisRx
2323 FCAD 92 88                 sta   (sccReg)
2324 FCAF A9 05                 lda   #5                       ;Now enable drivers for start of sync
2325 FCB1 A8                    tay                            ;Y = 5.
2326 FCB2 92 88                 sta   (sccReg)                 ;pulse.
2327 FCB4 A9 E3                 lda   #EnbRTS
2328 FCB6 92 88                 sta   (sccReg)
2329 FCB8 98                    tya                            ;Now disable drivers for end of sync
2330 FCB9 92 88                 sta   (sccReg)                 ;pulse
2331 FCBB A9 E1                 lda   #DisTxRTS
2332 FCBD 92 88                 sta   (sccReg)
2333 FCBF 98                    tya                            ;Now enable drivers and transmitter.
2334 FCC0 92 88                 sta   (sccReg)
2335 FCC2 A9 EB                 lda   #EnbTxRTS
2336 FCC4 92 88                 sta   (sccReg)
2337 FCC6 A0 1C 00              ldy   #T2Flags                 ;Delay long enough for two flags
2338 FCC9              FlagLoop                                ; ;to be transmitted. (50 usec)
2339 FCC9 88                    dey   
2340 FCCA D0 FD                 bne   FlagLoop
2341 FCCC A9 80                 lda   #ResTxCRC                ;Initialize the transmitter's CRC
2342 FCCE 92 88                 sta   (sccReg)                 ;generator.
2343 FCD0 8A                    txa                            ;Get the first character of the packet.
2344 FCD1 92 8A                 sta   (sccDat)                 ;Send it.
2345 FCD3 A9 C0                 lda   #ResetUnd                ;Reset transmit underrun error.
2346 FCD5 92 88                 sta   (sccReg)
2347 FCD7 60                    rts   
2348 FCD8                       ENDP 
2349 FCD8
2350 FCD8              ****************************************************************
2351 FCD8              *
2352 FCD8              *  'XmitOne' sends the byte in X to the SCC as soon as its transmit buffer
2353 FCD8              *  is empty.
2354 FCD8              *
2355 FCD8              *  Inputs:
2356 FCD8              *
2357 FCD8              *  Outputs:
2358 FCD8              *
2359 FCD8              ****************************************************************
2360 FCD8
2361 FCD8              XmitOne  PROC 
2362 FCD8
2363 FCD8 B2 88                 lda   (sccReg)                 ;Wait until the transmit buffer is
2364 FCDA 29 04                 and   #TxEmpty                 ;empty.
2365 FCDC F0 FA                 beq   XmitOne
2366 FCDE 8A                    txa                            ;Get char to transmit.
2367 FCDF 92 8A                 sta   (sccDat)
2368 FCE1 60                    rts   
2369 FCE2                       ENDP 
2370 FCE2
2371 FCE2              ****************************************************************
2372 FCE2              *
2373 FCE2              *  'BitCount' counts the set bits in A.
2374 FCE2              *
2375 FCE2              *  Inputs:  A: bits to count.
2376 FCE2              *
2377 FCE2              *  Outputs: Y: number of set bits.
2378 FCE2              *           flags: set from comparison of Y with 2.
2379 FCE2              *
2380 FCE2              ****************************************************************
2381 FCE2
2382 FCE2              BitCount PROC 
2383 FCE2 A2 07 00              ldx   #7                       ;Count 8 bits.
2384 FCE5 A0 00 00              ldy   #0                       ;# of set bits found.
2385 FCE8              BCLp                                    ; 
2386 FCE8 0A                    asl   A
2387 FCE9 90 01                 bcc   NotSet
2388 FCEB C8                    iny   
2389 FCEC              NotSet                                  ; 
2390 FCEC CA                    dex   
2391 FCED 10 F9                 bpl   bclp
2392 FCEF C0 02 00              cpy   #2
2393 FCF2 60                    rts   
2394 FCF3                       ENDP 
2395 FCF3
2396 FCF3              ****************************************************************
2397 FCF3              *
2398 FCF3              *  'WLineBusy' waits either until the line is busy or until the number of
2399 FCF3              *  100 usec. intervals specified by the Y register has passed.  If the line
2400 FCF3              *  is busy, C is set on return.  Otherwise, C is reset.
2401 FCF3              *
2402 FCF3              *  Inputs:
2403 FCF3              *
2404 FCF3              *  Outputs:
2405 FCF3              *
2406 FCF3              ****************************************************************
2407 FCF3
2408 FCF3              WLineBusy PROC 
2409 FCF3
2410 FCF3 84 92                 sty   r0                       ;Save counter in ZP.
2411 FCF5              WLBLp2                                  ; 
2412 FCF5 A0 07 00              ldy   #T100usec                ;100 usec. timer.
2413 FCF8 AE 8D 10              ldx   whichMouse               ;Get pointer to our mouse counter.
2414 FCFB              WLBLoop                                 ; 
2415 FCFB BD 00 00              lda   |0,x                     ;Clear mouse count.
2416 FCFE 20 66 FC              jsr   RTSAddr                  ;Wait about a bit time.
2417 FD01 BD 00 00              lda   |0,x                     ;See if any activity.
2418 FD04 D0 09                 bne   Busy                     ;Yes: exit.
2419 FD06 88                    dey                            ;Check for end of this 100usec period.
2420 FD07 D0 F2                 bne   WLBLoop                  ;Not the end.
2421 FD09 C6 92                 dec   r0                       ;Check for the end of the Y time.
2422 FD0B D0 E8                 bne   WLBLp2                   ;Not the end.
2423 FD0D 18                    clc                            ;Clear C to indicate time out
2424 FD0E 60                    rts                            ;and return.
2425 FD0F              Busy                                    ; 
2426 FD0F 38                    sec                            ;Set carry to indicate line busy
2427 FD10 60                    rts                            ;and return.
2428 FD11                       ENDP 
2429 FD11              ****************************************************************
2430 FD11              *
2431 FD11              *  'XmitBDS' transmits a data packet using the data from the buffer data
2432 FD11              *  structure pointed to by 'xmitBDS'.
2433 FD11              *
2434 FD11              *  Inputs:
2435 FD11              *
2436 FD11              *  Outputs:
2437 FD11              *
2438 FD11              ****************************************************************
2439 FD11
2440 FD11              XmitBDS  PROC 
2441 FD11
2442 FD11              ****************************************************************
2443 FD11              *
2444 FD11              *  This code sets up zero page pointers and registers X and Y for efficient
2445 FD11              *  access of the buffer data structure 'txBDS'.  X contains the number of
2446 FD11              *  bytes left in the current buffer, Y contains an offset from [ptr1] to the
2447 FD11              *  current byte in the buffer,  r0 is an offset from [ptr0] to the next entry
2448 FD11              *  in the BDS.
2449 FD11              *
2450 FD11              ****************************************************************
2451 FD11
2452 FD11 C2 20                 rep   #MBit                    ;16 bit A.
2453 FD13 AD 9C 10              lda   txBDS                    ;Get low word of BDS pointer.
2454 FD16 85 8C                 sta   ptr0                     ;Store in ZP.
2455 FD18 AD 9E 10              lda   txBDS+2                  ;Get high word.
2456 FD1B 85 8E                 sta   ptr0+2
2457 FD1D A7 8C                 lda   [ptr0]                   ;Get length of the first entry.
2458 FD1F 48                    pha                            ;Store length on stack.
2459 FD20 A0 02 00              ldy   #2                       ;Point to the first buffer address.
2460 FD23 B7 8C                 lda   [ptr0],y                 ;Get low word of address.
2461 FD25 85 8F                 sta   ptr1                     ;Store in ptr1
2462 FD27 C8                    iny                            ;Move on to high word.
2463 FD28 C8                    iny   
2464 FD29 B7 8C                 lda   [ptr0],y                 ;Get high word of address.
2465 FD2B 85 91                 sta   ptr1+2                   ;Store.
2466 FD2D C8                    iny                            ;Point to the next entry.
2467 FD2E C8                    iny   
2468 FD2F 84 92                 sty   r0                       ;Store pointer.
2469 FD31 E2 20                 sep   #MBit                    ;8 bit a.
2470 FD33 AD 94 10              lda   dest
2471 FD36 AA                    tax   
2472 FD37 20 A7 FC              jsr   XmitBegin
2473 FD3A AD 95 10              lda   source
2474 FD3D AA                    tax   
2475 FD3E 20 D8 FC              jsr   XmitOne
2476 FD41 AD 96 10              lda   lapType
2477 FD44 85 94                 sta   r2                       ;r2 is the first byte sent by XmitBDS.
2478 FD46 A0 00 00              ldy   #0                       ;Point to first byte of BDS data.
2479 FD49 FA                    plx                            ;Get back length of this BDS entry.
2480 FD4A F0 12                 beq   NextBDS                  ;Fixes 0 length bug 11/23/88  **TGH
2481 FD4C
2482 FD4C              XmitBytes                               ; 
2483 FD4C B2 88                 lda   (sccReg)                 ;Wait for the transmit buffer to be
2484 FD4E 29 04                 and   #TxEmpty                 ;empty.
2485 FD50 F0 FA                 beq   XmitBytes
2486 FD52 A5 94                 lda   r2                       ;Then get the first byte to send,
2487 FD54 92 8A                 sta   (sccDat)                 ;and send it.
2488 FD56 B7 8F                 lda   [ptr1],y                 ;Get a byte from the BDS.
2489 FD58 85 94                 sta   r2                       ;Store it.
2490 FD5A C8                    iny                            ;Point to next byte.
2491 FD5B CA                    dex                            ;See if this entry is empty.
2492 FD5C D0 EE                 bne   XmitBytes                ;No, keep looping.
2493 FD5E
2494 FD5E C2 21        NextBDS  rep   #MBit+CBit               ;16 bit A, clear C.
2495 FD60                       longa on
2496 FD60 A4 92                 ldy   r0                       ;Get pointer to next BDS entry.
2497 FD62 B7 8C                 lda   [ptr0],y                 ;Get length of next entry.
2498 FD64 D0 09                 bne   NotZ                     ;See if length is zero.
2499 FD66              Again                                   ; 
2500 FD66 98                    tya                            ;It is: move on the next BDS entry.
2501 FD67 69 06 00              adc   #6
2502 FD6A A8                    tay   
2503 FD6B B7 8C                 lda   [ptr0],y                 ;Is it still zero?
2504 FD6D F0 F7                 beq   Again
2505 FD6F              NotZ                                    ; ;Not zero: send the BDS entry.
2506 FD6F AA                    tax                            ;Put the count in X.
2507 FD70 1A                    inc   A                        ;If $ffff, it's the end.
2508 FD71 F0 17                 beq   Empty
2509 FD73 C8                    iny                            ;Move ahead to the buffer pointer.
2510 FD74 C8                    iny   
2511 FD75 B7 8C                 lda   [ptr0],y                 ;Get low word of pointer.
2512 FD77 85 8F                 sta   ptr1                     ;Store it.
2513 FD79 C8                    iny                            ;Move on to high byte.
2514 FD7A C8                    iny   
2515 FD7B E2 20                 sep   #MBit                    ;Back to 8 bits.
2516 FD7D                       longa off
2517 FD7D B7 8C                 lda   [ptr0],y                 ;Get high byte.
2518 FD7F 85 91                 sta   ptr1+2                   ;Store it.
2519 FD81 C8                    iny                            ;Move on to the next entry.
2520 FD82 C8                    iny   
2521 FD83 84 92                 sty   r0                       ;Save pointer to the next entry.
2522 FD85 A0 00 00              ldy   #0                       ;Point to the first byte of the entry.
2523 FD88 80 C2                 bra   XmitBytes                ;Keep sending bytes.
2524 FD8A              Empty                                   ; 
2525 FD8A E2 20                 sep   #MBit                    ;Back to 8 bits.
2526 FD8C A5 94                 lda   r2                       ;Get the last byte.
2527 FD8E AA                    tax                            ;Put in X for XmitEnd.
2528 FD8F
2529 FD8F              ****************************************************************
2530 FD8F              *
2531 FD8F              *  'XmitEnd' terminates a packet transmission by sending the byte passed in X,
2532 FD8F              *  the trailing flag, and the abort sequence.  It then inits the receiver.
2533 FD8F              *
2534 FD8F              *  Inputs:
2535 FD8F              *
2536 FD8F              *  Outputs:
2537 FD8F              *
2538 FD8F              ****************************************************************
2539 FD8F
2540 FD8F                       entry XmitEnd                  ; EXPORT -> ENTRY  **TGH
2541 FD8F              XmitEnd                                 ;
2542 FD8F 20 D8 FC              jsr   XmitOne                  ;Send the byte in X.
2543 FD92              UndWait                                 ; 
2544 FD92 B2 88                 lda   (sccReg)                 ;Then, wait for underrun.
2545 FD94 29 40                 and   #Underrun
2546 FD96 F0 FA                 beq   UndWait
2547 FD98              CRCWait                                 ; ;Then, wait for CRC to be transmitted.
2548 FD98 B2 88                 lda   (sccReg)
2549 FD9A 29 04                 and   #TxEmpty                 ;(Full while sending CRC bytes).
2550 FD9C F0 FA                 beq   CRCWait
2551 FD9E A2 10 00              ldx   #TLastFlag               ;Wait long enough for the terminating
2552 FDA1              FlagWait                                ; ;flag to be sent (29 usec).
2553 FDA1 CA                    dex   
2554 FDA2 D0 FD                 bne   FlagWait
2555 FDA4 A9 05                 lda   #5                       ;Now disable transmitter but keep
2556 FDA6 92 88                 sta   (sccReg)                 ;drivers on for abort sequence.
2557 FDA8 A9 E3                 lda   #EnbRTS
2558 FDAA 92 88                 sta   (sccReg)
2559 FDAC A2 2A 00              ldx   #TAbort                  ;Wait long enough for the abort
2560 FDAF              AbortWait                               ; ;sequence to happen (75 usec).
2561 FDAF CA                    dex   
2562 FDB0 D0 FD                 bne   AbortWait
2563 FDB2 A9 05                 lda   #5                       ;Now turn off drivers.
2564 FDB4 92 88                 sta   (sccReg)
2565 FDB6 A9 E1                 lda   #DisTxRTS
2566 FDB8 92 88                 sta   (sccReg)                 ;Fall into 'RecvInit'.
2567 FDBA
2568 FDBA              ****************************************************************
2569 FDBA              *
2570 FDBA              *  'RecvInit' initializes the current appletalk SCC channel for packet
2571 FDBA              *  reception.
2572 FDBA              *
2573 FDBA              ****************************************************************
2574 FDBA
2575 FDBA                       entry RecvInit                 ; EXPORT -> ENTRY  **TGH
2576 FDBA              RecvInit                                ;
2577 FDBA 08                    php                            ;Save int mode.
2578 FDBB 78                    sei                            ;No interrupts.
2579 FDBC F4 DD 00              pea   $00DD                    ;(EnbRxSlv+EnterHunt) + End flag
2580 FDBF F4 30 23              pea   $2330                    ;(ResetErr+256*(ReEnbInt+3))
2581 FDC2 F4 03 D0              pea   $D003                    ;(3+256*DisRx)
2582 FDC5              RILp                                    ; 
2583 FDC5 68                    pla   
2584 FDC6 92 88                 sta   (sccReg)
2585 FDC8 D0 FB                 bne   RILp
2586 FDCA 28                    plp                            ;Get back int mode.
2587 FDCB 60                    rts   
2588 FDCC              * The above code sends out the following sequence of bytes to the control reg.:
2589 FDCC              *           #3                          Point to write register 3.
2590 FDCC              *           #DisRx                      Disable the receiver.
2591 FDCC              *           #ResetErr                   Reset Errors.
2592 FDCC              *           #ReEnbInt+3                 Enable 1st char ints, point to reg 3.
2593 FDCC              *           #EnbRxSlv+EnterHunt         Set slave receive mode.
2594 FDCC                       ENDP 
2595 FDCC
2596 FDCC              ****************************************************************
2597 FDCC              *
2598 FDCC              *  'NewPacket' checks the latest packet to see if it belongs to an installed
2599 FDCC              *  protocol handler.  If so, it is added to the packet dispatch list.  If not,
2600 FDCC              *  it is discarded.  LCBank RAM must be selected before calling.
2601 FDCC              *
2602 FDCC              *  Inputs:  ptr0 = curEnd.  16 bit index, 8 bit A.
2603 FDCC              *
2604 FDCC              *  Outputs:
2605 FDCC              *
2606 FDCC              ****************************************************************
2607 FDCC
2608 FDCC              NewPacket PROC 
2609 FDCC
2610 FDCC C2 20                 rep   #MBit                    ;16 bit A.
2611 FDCE                       longa on
2612 FDCE AE AD 10              ldx   curWBuf                  ;X points to the base of the buffer.
2613 FDD1 88                    dey                            ;Adjust end of buffer (skip CRC byte).
2614 FDD2 98                    tya                            ;(Y points to CRC, 1st byte past data).
2615 FDD3 38                    sec   
2616 FDD4 ED AF 10              sbc   curOffset                ;Subtract the base of the data to
2617 FDD7 9D 02 00              sta   |buf_len,x               ;find the length.  Store in buffer.
2618 FDDA B7 8C                 lda   [ptr0],y                 ;Get that pesky CRC byte.
2619 FDDC 29 FF 00              and   #$ff                     ;Mask high byte.
2620 FDDF 48                    pha                            ;Save on stack.
2621 FDE0 AD A2 10              lda   ckSum                    ;Get the checksum.
2622 FDE3 6A                    ror   A                        ;Look at the low bit.
2623 FDE4 08                    php                            ;Save carry bit.
2624 FDE5 2A                    rol   A                        ;Back to the checksum.
2625 FDE6 28                    plp                            ;Get the low bit back in C.
2626 FDE7 6A                    ror   A                        ;NOW rotate right.
2627 FDE8 38                    sec                            ;Prepare to subtract.
2628 FDE9 E3 01                 sbc   1,s                      ;Subtract the CRC: now we have the real
2629 FDEB 9D 04 00              sta   |buf_cksum,x             ;checksum.  Put it in the buffer.
2630 FDEE 68                    pla                            ;Clean up the stack.
2631 FDEF AD A6 10              lda   scc1A                    ;Get scc bytes and install in buffer.
2632 FDF2 9D 06 00              sta   |buf_dest,x              ;Store first and second bytes.
2633 FDF5 E2 20                 sep   #MBit                    ;Back to 8 bit A.
2634 FDF7                       longa off
2635 FDF7 AD A8 10              lda   scc3                     ;Now get third byte.
2636 FDFA 9D 08 00              sta   |buf_type,x
2637 FDFD C2 20                 rep   #MBit                    ;16 bit A.
2638 FDFF                       longa on
2639 FDFF 98                    tya                            ;A = curOffset.
2640 FE00 18                    clc   
2641 FE01 6D B1 10              adc   curEnd                   ;Advance the end packet pointer past
2642 FE04 18                    clc                            ;the packet we just got.
2643 FE05 69 63 02              adc   #MaxSize
2644 FE08 8D B1 10              sta   curEnd
2645 FE0B 30 0B                 bmi   OK                       ;If curEnd is still > $8000, it's OK.
2646 FE0D A9 63 E2              lda   #Base+MaxSize            ;Otherwise, wrap back to the beginning
2647 FE10 8D B1 10              sta   curEnd                   ;of the packet buffer area.
2648 FE13 E2 20                 sep   #MBit
2649 FE15                       longa off                      ;Also,
2650 FE15 EE 56 10              inc   trailing                 ;set the trailing flag to indicate that
2651 FE18              OK                                      ; ;write pointers precede read pointers.
2652 FE18              ;                                       ;End by setting up the next write buf.
2653 FE18
2654 FE18              ****************************************************************
2655 FE18              *
2656 FE18              *  'SetWNext' sets up 'curOffset', curWBuf->next, and 'curWBuf' to add the most
2657 FE18              *  recent write buffer to the list.  If there isn't enough room to allocate the
2658 FE18              *  next write buffer, 'curOffset' is set to zero to prevent 'RecvPacket' from
2659 FE18              *  storing packets.
2660 FE18              *
2661 FE18              ****************************************************************
2662 FE18
2663 FE18                       entry SetWNext                 ; EXPORT -> ENTRY  **TGH
2664 FE18              SetWNext                                ;
2665 FE18 E2 20                 sep   #MBit                    ;8 bit A.
2666 FE1A AE AD 10              ldx   curWBuf                  ;X points to the current write buffer.
2667 FE1D AD 56 10              lda   trailing                 ;See if trailing.
2668 FE20 C2 21                 rep   #MBit+CBit               ;16 bit A.
2669 FE22                       longa on
2670 FE22 F0 13                 beq   NotTrail                 ;If trailing, check for full buffer.
2671 FE24 AC A9 10              ldy   curRBuf                  ;See if curEnd > curRBuf.
2672 FE27 CC B1 10              cpy   curEnd
2673 FE2A B0 0B                 bcs   NotTrail                 ;If not, the buffer isn't full.
2674 FE2C A9 00 00              lda   #0                       ;If so, the buffer is full.  Indicate
2675 FE2F 9D 00 00              sta   |buf_next,x              ;full buffer: set curWBuf->next = 0.
2676 FE32 8D AF 10              sta   curOffset                ;Also, curOffset = 0.
2677 FE35 80 17                 bra   Exit
2678 FE37              NotTrail                                ; 
2679 FE37 38                    sec   
2680 FE38 AD B1 10              lda   curEnd                   ;set curWBuf->next = curEnd - MaxSize
2681 FE3B E9 63 02              sbc   #MaxSize                 ;to point to the beginning of the next
2682 FE3E 9D 00 00              sta   |buf_next,x              ;write buffer.
2683 FE41 8D AD 10              sta   curWBuf                  ;Now use that buffer as curWBuf.
2684 FE44 AA                    tax                            ;Now clear curWBuf->next to indicate
2685 FE45 9E 00 00              stz   |buf_next,x              ;empty buffer.
2686 FE48 A9 A6 FD              lda   #-(MaxData+2)            ;Set up curOffset to point to the
2687 FE4B 8D AF 10              sta   curOffset                ;start of the LAP data field.
2688 FE4E              Exit                                    ; 
2689 FE4E E2 20                 sep   #MBit                    ;Back to 8 bit A.
2690 FE50                       longa off
2691 FE50 60                    rts   
2692 FE51
2693 FE51              ****************************************************************
2694 FE51              *
2695 FE51              *  'FreeBuf' releases the current read buffer for future use.
2696 FE51              *  LCBank RAM must be selected before calling.
2697 FE51              *
2698 FE51              ****************************************************************
2699 FE51              *
2700 FE51                       entry FreeBuf                  ; EXPORT -> ENTRY  **TGH
2701 FE51              FreeBuf                                 ;
2702 FE51 AE A9 10              ldx   curRBuf                  ;Point to the buffer.
2703 FE54 BC 00 00              ldy   |buf_next,x              ;Get curRBuf->next.
2704 FE57 CC A9 10              cpy   curRBuf                  ;If next < curRBuf, we're wrapping to
2705 FE5A B0 03                 bcs   NotWrap                  ;the beginning of the buffer, so we
2706 FE5C 9C 56 10              stz   trailing                 ;reset the trailing flag.
2707 FE5F              NotWrap                                 ; 
2708 FE5F 8C A9 10              sty   curRBuf                  ;Point curRBuf to the next buffer.
2709 FE62 AC AF 10              ldy   curOffset                ;See if curOffset is 0.
2710 FE65 F0 B1                 beq   SetWNext                 ;If so, try to get a new write buffer.
2711 FE67 60                    rts                            ;Otherwise, return.
2712 FE68                       ENDP 
2713 FE68
2714 FE68              ****************************************************************
2715 FE68              *
2716 FE68              *  'Dispatch' dispatches packets from the list until there are none left or
2717 FE68              *  'busyFlag' is greater than zero.  Control is passed to each packet's
2718 FE68              *  protocol handler.
2719 FE68              *
2720 FE68              *  Inputs:  8 bit A, 16 bit index.
2721 FE68              *
2722 FE68              *  Outputs:
2723 FE68              *
2724 FE68              ****************************************************************
2725 FE68
2726 FE68              Dispatch PROC EXPORT 
2727 FE68
2728 FE68 08                    php   
2729 FE69 AF F8 07 00           lda   >$0007f8                 ;get mslot
2730 FE6D 48                    pha                            ;hold till we are ready to exit
2731 FE6E 20 8A FE              jsr   predispatch
2732 FE71 68                    pla                            ;recover mslot
2733 FE72 8F F8 07 00           sta   >$0007f8                 ;restore it
2734 FE76 C9 C1                 cmp   #$c1                     ;see if in valid range
2735 FE78 90 0E                 bcc   notgoodmslot             ;no it is not
2736 FE7A C2 10                 rep   #xbit
2737 FE7C EB                    xba                            ;a=$cnXX
2738 FE7D A9 00                 lda   #00                      ;a=$cn00
2739 FE7F AA                    tax   
2740 FE80 AF FF CF 00           lda   >$00cfff                 ;deselect all $c800's
2741 FE84 BF 00 00 00           lda   >$000000,x               ;access $cn00 to re-enable original $c800
2742 FE88              notgoodmslot                            ; 
2743 FE88 28                    plp   
2744 FE89 6B                    rtl   
2745 FE8A
2746 FE8A
2747 FE8A              predispatch                             ; 
2748 FE8A 20 95 FE              jsr   stacksave                ;save stack and move pointer
2749 FE8D 22 4D FF FD           jsl   coredispatch             ;dispatch packet
2750 FE91 20 0D FF              jsr   stackrestore             ;restore stack pointer
2751 FE94 60                    rts   
2752 FE95
2753 FE95
2754 FE95              * stack saving routines...
2755 FE95              * these routines will save a portion of the stack to
2756 FE95              * allow deeper than normal nesting of calls on the 256 byte stack
2757 FE95              *
2758 FE95
2759 FE95                       EXPORT stacksave 
2760 FE95              stacksave                               ;
2761 FE95 8B                    phb                            ;save bank
2762 FE96 8B                    phb   
2763 FE97 22 B0 F9 FD           jsl   LongForbid               ;don't let other ints come in here
2764 FE9B F4 E1 E1              pea   $e1e1
2765 FE9E AB                    plb   
2766 FE9F AB                    plb                            ;must be in bank e1 for vars
2767 FEA0 8D 5D 11              sta   stacksavea               ;save accum
2768 FEA3 08                    php                            ;save register modes
2769 FEA4 08                    php   
2770 FEA5 C2 30                 rep   #mbit+xbit               ;force full native
2771 FEA7                       longa on
2772 FEA7                       longi on
2773 FEA7 68                    pla                            ;recover old mode in accum
2774 FEA8 8D 65 11              sta   stacksavep
2775 FEAB 68                    pla                            ;get data bank (pushed at entry)
2776 FEAC 8D 63 11              sta   stacksaveb               ;save the data bank
2777 FEAF 8E 5F 11              stx   stacksavex
2778 FEB2 8C 61 11              sty   stacksavey               ;save registers
2779 FEB5 68                    pla                            ;get return address
2780 FEB6 8D 57 11              sta   stretaddr                ;hold onto return address since we change stacks
2781 FEB9 EE 55 11              inc   stksaveflag              ;bump the flag so nested calls don't save stack
2782 FEBC AD 55 11              lda   stksaveflag              ;see if stack already saved
2783 FEBF 3A                    dec   a                        ;see if is now 1
2784 FEC0 D0 2D                 bne   stackok                  ;the stack is already saved or ok since above 1
2785 FEC2 3B                    tsc                            ;get real stack pointer
2786 FEC3 C9 A0 01              cmp   #topstack                ;check against our prefferred top of stack
2787 FEC6 90 05                 bcc   stackswap                ;it's lower, do stack stuff
2788 FEC8 9C 5B 11              stz   oldstack                 ;zero out pointer so restore knows we did nothing
2789 FECB 80 22                 bra   stackok
2790 FECD              stackswap                               ; 
2791 FECD 8D 5B 11              sta   oldstack                 ;preserve stack pointer for restore later
2792 FED0 38                    sec   
2793 FED1 A9 A0 01              lda   #topstack                ;get value of where we want stack
2794 FED4 ED 5B 11              sbc   oldstack                 ;see how many bytes we need to save
2795 FED7 C9 A0 00              cmp   #topstack-$100           ;see if stack below $100
2796 FEDA B0 03                 bcs   @dothesave               ;no, so save it
2797 FEDC A9 A0 00              lda   #topstack-$100           ;it was, so only save from $100, not below
2798 FEDF              @dothesave  
2799 FEDF 8D 59 11              sta   lentosave                ;save for later restore
2800 FEE2 AE 5B 11              ldx   oldstack                 ;recover stack pointer
2801 FEE5 A0 B4 10              ldy   #ourstacksave            ;destination is ourstacksave memory
2802 FEE8 54 E1 00              mvn   $00,$e1e1e1              ;move from stack to our bank
2803 FEEB A9 A0 01              lda   #topstack                ;get our stack pointer
2804 FEEE 1B                    tcs                            ;and set it
2805 FEEF              stackok                                 ; 
2806 FEEF AD 57 11              lda   stretaddr                ;recover return address
2807 FEF2 48                    pha   
2808 FEF3 AE 5F 11              ldx   stacksavex               ;recover x and y
2809 FEF6 AC 61 11              ldy   stacksavey
2810 FEF9 AD 63 11              lda   stacksaveb               ;get old data bank
2811 FEFC 48                    pha                            ;stay in bank $e1 till end
2812 FEFD AD 65 11              lda   stacksavep               ;now restore processor state
2813 FF00 48                    pha                            ;push two identical bytes
2814 FF01 28                    plp   
2815 FF02 28                    plp                            ;restore original state of processor
2816 FF03 AD 5D 11              lda   stacksavea               ;and finally restore a
2817 FF06 AB                    plb                            ;restore data bank that was pushed above
2818 FF07 AB                    plb                            ;now since we don't need to be in bank $e1 now
2819 FF08 22 B4 F9 FD           jsl   LongPermit               ;allow atalk to dispatch again
2820 FF0C 60                    rts                            ;and return
2821 FF0D
2822 FF0D                       EXPORT stackrestore 
2823 FF0D              stackrestore                            ;
2824 FF0D 8B                    phb                            ;save bank
2825 FF0E 8B                    phb   
2826 FF0F 22 B0 F9 FD           jsl   LongForbid               ;don't let other ints come in here
2827 FF13 F4 E1 E1              pea   $e1e1
2828 FF16 AB                    plb   
2829 FF17 AB                    plb                            ;must be in bank e1 for vars
2830 FF18 8D 5D 11              sta   stacksavea               ;save accum
2831 FF1B 08                    php                            ;save register modes
2832 FF1C 08                    php   
2833 FF1D C2 30                 rep   #mbit+xbit               ;force full native
2834 FF1F                       longa on
2835 FF1F                       longi on
2836 FF1F 68                    pla                            ;recover old mode in accum
2837 FF20 8D 65 11              sta   stacksavep
2838 FF23 68                    pla                            ;get data bank pushed earlier
2839 FF24 8D 63 11              sta   stacksaveb               ;save the data bank
2840 FF27 8E 5F 11              stx   stacksavex
2841 FF2A 8C 61 11              sty   stacksavey               ;save registers
2842 FF2D 68                    pla   
2843 FF2E 8D 57 11              sta   stretaddr                ;save return
2844 FF31 CE 55 11              dec   stksaveflag              ;lower level
2845 FF34 D0 B9                 bne   stackok                  ;we are still nested
2846 FF36 AD 5B 11              lda   oldstack                 ;recover old stack pointer
2847 FF39 F0 B4                 beq   stackok                  ;nothing ever saved
2848 FF3B 1B                    tcs                            ;put it back where it was originally
2849 FF3C A8                    tay                            ;data will start storing here in mvn
2850 FF3D A2 B4 10              ldx   #ourstacksave            ;area to restore stack from
2851 FF40 AD 59 11              lda   lentosave                ;amount to restore onto stack
2852 FF43 54 00 E1              mvn   $e1e1e1,$00              ;move from ourbank to stack bank
2853 FF46 F4 E1 E1              pea   $e1e1
2854 FF49 AB                    plb   
2855 FF4A AB                    plb                            ;set data bank back to our code bank
2856 FF4B 80 A2                 bra   stackok                  ;exit this routine
2857 FF4D              *
2858 FF4D              * end of stacksave routines and equates
2859 FF4D              *
2860 FF4D
2861 FF4D
2862 FF4D              coreDispatch                            ; 
2863 FF4D                       longa off
2864 FF4D                       longi on
2865 FF4D 08                    php   
2866 FF4E              Loop                                    ; 
2867 FF4E AD 53 10              lda   busyFlag                 ;Our ordinary 'non-busy' value is
2868 FF51 C9 01                 cmp   #1                       ;actually 1, not zero.  Exit loop if
2869 FF53 D0 1A                 bne   Exit                     ;not 1 (someone else did 'EnterCrit').
2870 FF55 08                    php                            ;lets see if any ticks have occurred
2871 FF56 78                    sei                            ;lock out ints, since qtr ints can change deltaT on us
2872 FF57 AD 55 10              lda   deltaT                   ;get qtr second ticks
2873 FF5A 9C 55 10              stz   deltaT                   ;always zero it out, since we will make use of whats in A
2874 FF5D 28                    plp   
2875 FF5E 09 00                 ora   #00                      ;check value of deltaT
2876 FF60 C2 20                 rep   #MBit                    ;16 bit A.
2877 FF62                       longa on
2878 FF62 F0 03                 beq   @checkpkt                ;no ticks to dispatch
2879 FF64 20 1E EF              jsr   QtrSched                 ;we have ticks, give them a call!
2880 FF67              @checkpkt                               ;check to see if we have packets to dispatch
2881 FF67 AE A9 10              ldx   curRBuf                  ;Get pointer to the packet.
2882 FF6A BD 00 00              lda   |buf_next,x              ;See if next field is 0.
2883 FF6D D0 02                 bne   IsData                   ;If not, there is some data.
2884 FF6F              Exit                                    ; ;Otherwise, return.
2885 FF6F 28                    plp   
2886 FF70 6B                    rtl   
2887 FF71              IsData                                  ; 
2888 FF71 86 80                 stx   zpCurBuf                 ;Store pointer to the buffer in ZP.
2889 FF73 BD 06 00              lda   |buf_dest,x              ;get dest node, and source node
2890 FF76 8D 00 D0              sta   |LapDest                 ;save it
2891 FF79 BD 02 00              lda   |buf_len,x               ;Get the length of the packet.
2892 FF7C 8D AB 10              sta   curLen                   ;Store as current length.
2893 FF7F 8A                    txa                            ;Get pointer to the buffer.
2894 FF80 18                    clc   
2895 FF81 69 09 00              adc   #buf_data                ;Point to the LAP data field.
2896 FF84 8D 57 10              sta   curPos                   ;Set the read position pointer for
2897 FF87 E2 20                 sep   #MBit                    ;ReadProt and ReadRest.  8 bit A.
2898 FF89                       longa off
2899 FF89 BD 08 00              lda   |buf_type,x              ;Get the LAP type.
2900 FF8C 8D 02 D0              sta   |LapDest+2               ;and save it for getglobal
2901 FF8F 20 63 F7              jsr   FindProt                 ;Try to find a protocol handler for
2902 FF92 90 16                 bcc   NoProt                   ;the packet.
2903 FF94 C2 20                 rep   #MBit                    ;Back to 16 bit A.
2904 FF96 BC 7D 10              ldy   |protTable+4*MaxProts,X  ;Y = high worrd of handler address.
2905 FF99 BD 6D 10              lda   |protTable+2*MaxProts,X  ;A = low word of handler address.
2906 FF9C              Callhandler                             ; 
2907 FF9C 85 84                 sta   execAddr
2908 FF9E 84 86                 sty   execAddr+2               ;Call the routine, using emulation mode
2909 FFA0 22 8A E9 FD           jsl   GoComp                   ;for bank 0, fixing stack if needed.
2910 FFA4 E2 20                 sep   #MBit
2911 FFA6 C2 10                 rep   #XBit
2912 FFA8 80 A4                 bra   Loop                     ;Loop until busy.
2913 FFAA              NoProt                                  ; 
2914 FFAA AC 59 10              ldy   catchProt                ;Is there a catch all prot. handler?
2915 FFAD D0 0A                 bne   IsCatch
2916 FFAF AC 5B 10              ldy   catchProt+2
2917 FFB2 D0 05                 bne   IsCatch
2918 FFB4 20 51 FE              jsr   FreeBuf                  ;No handler: release the buffer.
2919 FFB7 80 95                 bra   Loop
2920 FFB9              IsCatch                                 ; 
2921 FFB9 C2 20                 rep   #MBit                    ;16 bit A.
2922 FFBB AD 59 10              lda   catchProt                ;Get low word of handler address.
2923 FFBE AC 5B 10              ldy   catchProt+2              ;Get high word of handler address.
2924 FFC1 80 D9                 bra   CallHandler
2925 FFC3                       ENDP 
2926 FFC3
2927 FFC3                       END   
